/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.util.ArrayList;
import java.util.List;

public abstract class OutputExpression
extends Expression {
    private final String image;
    private final String fieldName;

    public OutputExpression(String image, String fieldName) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.image = image;
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.tryOutputType(this.fieldName, context.getCurrentType(), this);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setFieldValue(this.fieldName, context.getCurrentValue(), this);
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    @Override
    public DataType getInputType(VerificationContext context) {
        return context.getFieldType(this.fieldName, this);
    }

    public String toString() {
        return this.image + (String)(this.fieldName != null ? " " + this.fieldName : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OutputExpression)) {
            return false;
        }
        OutputExpression rhs = (OutputExpression)((Object)obj);
        return OutputExpression.equals(this.fieldName, rhs.fieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + (this.fieldName != null ? this.fieldName.hashCode() : 0);
    }

    public static class OutputFieldNameExtractor
    implements ObjectOperation,
    ObjectPredicate {
        private final List<String> outputFieldNames = new ArrayList<String>(1);

        public List<String> getOutputFieldNames() {
            return this.outputFieldNames;
        }

        public void execute(Object obj) {
            this.outputFieldNames.add(((OutputExpression)((Object)obj)).getFieldName());
        }

        public boolean check(Object obj) {
            return obj instanceof OutputExpression;
        }
    }
}

