/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Transformer;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NormalizeExpression
extends Expression {
    private final Linguistics linguistics;
    private static final Logger logger = Logger.getLogger(NormalizeExpression.class.getName());

    public NormalizeExpression(Linguistics linguistics) {
        super((DataType)DataType.STRING);
        this.linguistics = linguistics;
    }

    public Linguistics getLinguistics() {
        return this.linguistics;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType(this.createdOutputType());
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        Transformer transformer = this.linguistics.getTransformer();
        String orig = String.valueOf(context.getCurrentValue());
        if (orig.isEmpty()) {
            return;
        }
        Language lang = context.resolveLanguage(this.linguistics);
        String transformed = transformer.accentDrop(orig, lang);
        try {
            context.setCurrentValue((FieldValue)new StringFieldValue(transformed));
            return;
        }
        catch (IllegalArgumentException ex) {
            String msg = "bad normalize, \noriginal: >>> " + NormalizeExpression.escape(orig) + " <<<\n -> accentDrop(" + lang + ") -> \ntransformed: >>> " + NormalizeExpression.escape(transformed) + " <<<";
            logger.log(Level.SEVERE, msg);
            context.setCurrentValue((FieldValue)new StringFieldValue(transformer.accentDrop(String.valueOf(context.getCurrentValue()), context.resolveLanguage(this.linguistics))));
            return;
        }
    }

    private static String escape(String str) {
        StringBuilder buf = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c >= ' ') {
                buf.append(c);
                continue;
            }
            buf.append(String.format("U+%04X", c));
        }
        return buf.toString();
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "normalize";
    }

    public boolean equals(Object o) {
        if (!(o instanceof NormalizeExpression)) {
            return false;
        }
        NormalizeExpression other = (NormalizeExpression)((Object)o);
        return this.linguistics.getClass() == other.linguistics.getClass();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

