/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.vespa.indexinglanguage.expressions.ArithmeticExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class MathResolver {
    private final List<Item> items = new LinkedList<Item>();

    public void push(ArithmeticExpression.Operator op, Expression exp) {
        if (this.items.isEmpty() && op != ArithmeticExpression.Operator.ADD) {
            throw new IllegalArgumentException("First item in an arithmetic operation must be an addition, not " + op);
        }
        this.items.add(new Item(op, exp));
    }

    public Expression resolve() {
        ArrayDeque<Item> stack = new ArrayDeque<Item>();
        stack.push(this.items.remove(0));
        while (!this.items.isEmpty()) {
            Item item = this.items.remove(0);
            while (stack.size() > 1 && ((Item)stack.peek()).op.precedes(item.op)) {
                this.pop(stack);
            }
            stack.push(item);
        }
        while (stack.size() > 1) {
            this.pop(stack);
        }
        return ((Item)stack.pop()).exp;
    }

    private void pop(Deque<Item> stack) {
        Item rhs = stack.pop();
        Item lhs = stack.peek();
        lhs.exp = new ArithmeticExpression(lhs.exp, rhs.op, rhs.exp);
    }

    private static class Item {
        final ArithmeticExpression.Operator op;
        Expression exp;

        Item(ArithmeticExpression.Operator op, Expression exp) {
            this.op = Objects.requireNonNull(op);
            this.exp = exp;
        }
    }
}

