/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;

public final class ArithmeticExpression
extends CompositeExpression {
    private final Expression left;
    private final Operator op;
    private final Expression right;

    public ArithmeticExpression(Expression left, Operator op, Expression right) {
        super(ArithmeticExpression.requiredInputType(left, right));
        this.left = Objects.requireNonNull(left);
        this.op = Objects.requireNonNull(op);
        this.right = Objects.requireNonNull(right);
    }

    public Expression getLeftHandSide() {
        return this.left;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getRightHandSide() {
        return this.right;
    }

    @Override
    public ArithmeticExpression convertChildren(ExpressionConverter converter) {
        return new ArithmeticExpression(converter.convert(this.left), this.op, converter.convert(this.right));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getCurrentType();
        context.setCurrentType(this.evaluate(context.setCurrentType(input).verify(this.left).getCurrentType(), context.setCurrentType(input).verify(this.right).getCurrentType()));
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        context.setCurrentValue(this.evaluate(context.setCurrentValue(input).execute(this.left).getCurrentValue(), context.setCurrentValue(input).execute(this.right).getCurrentValue()));
    }

    private static DataType requiredInputType(Expression lhs, Expression rhs) {
        DataType lhsType = lhs.requiredInputType();
        DataType rhsType = rhs.requiredInputType();
        if (lhsType == null) {
            return rhsType;
        }
        if (rhsType == null) {
            return lhsType;
        }
        if (!lhsType.equals((Object)rhsType)) {
            throw new VerificationException(ArithmeticExpression.class, "Operands require conflicting input types, " + lhsType.getName() + " vs " + rhsType.getName());
        }
        return lhsType;
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return this.left + " " + this.op + " " + this.right;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArithmeticExpression)) {
            return false;
        }
        ArithmeticExpression expression = (ArithmeticExpression)((Object)object);
        if (!((Object)((Object)this.left)).equals((Object)expression.left)) {
            return false;
        }
        if (!this.op.equals((Object)expression.op)) {
            return false;
        }
        return ((Object)((Object)this.right)).equals((Object)expression.right);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.left)).hashCode() + this.op.hashCode() + ((Object)((Object)this.right)).hashCode();
    }

    private DataType evaluate(DataType lhs, DataType rhs) {
        if (lhs == null || rhs == null) {
            throw new VerificationException(this, "Attempting to perform arithmetic on a null value");
        }
        if (!(lhs instanceof NumericDataType) || !(rhs instanceof NumericDataType)) {
            throw new VerificationException(this, "Attempting to perform unsupported arithmetic: [" + lhs.getName() + "] " + this.op + " [" + rhs.getName() + "]");
        }
        if (lhs == DataType.FLOAT || lhs == DataType.DOUBLE || rhs == DataType.FLOAT || rhs == DataType.DOUBLE) {
            if (lhs == DataType.DOUBLE || rhs == DataType.DOUBLE) {
                return DataType.DOUBLE;
            }
            return DataType.FLOAT;
        }
        if (lhs == DataType.LONG || rhs == DataType.LONG) {
            return DataType.LONG;
        }
        return DataType.INT;
    }

    private FieldValue evaluate(FieldValue lhs, FieldValue rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (!(lhs instanceof NumericFieldValue) || !(rhs instanceof NumericFieldValue)) {
            throw new IllegalArgumentException("Unsupported operation: [" + lhs.getDataType().getName() + "] " + this.op + " [" + rhs.getDataType().getName() + "]");
        }
        BigDecimal lhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)lhs);
        BigDecimal rhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)rhs);
        return switch (this.op) {
            default -> throw new IncompatibleClassChangeError();
            case Operator.ADD -> this.createFieldValue(lhs, rhs, lhsVal.add(rhsVal));
            case Operator.SUB -> this.createFieldValue(lhs, rhs, lhsVal.subtract(rhsVal));
            case Operator.MUL -> this.createFieldValue(lhs, rhs, lhsVal.multiply(rhsVal));
            case Operator.DIV -> this.createFieldValue(lhs, rhs, lhsVal.divide(rhsVal, MathContext.DECIMAL64));
            case Operator.MOD -> this.createFieldValue(lhs, rhs, lhsVal.remainder(rhsVal));
        };
    }

    private FieldValue createFieldValue(FieldValue lhs, FieldValue rhs, BigDecimal val) {
        if (lhs instanceof FloatFieldValue || lhs instanceof DoubleFieldValue || rhs instanceof FloatFieldValue || rhs instanceof DoubleFieldValue) {
            if (lhs instanceof DoubleFieldValue || rhs instanceof DoubleFieldValue) {
                return new DoubleFieldValue(val.doubleValue());
            }
            return new FloatFieldValue(val.floatValue());
        }
        if (lhs instanceof LongFieldValue || rhs instanceof LongFieldValue) {
            return new LongFieldValue(val.longValue());
        }
        return new IntegerFieldValue(val.intValue());
    }

    public static BigDecimal asBigDecimal(NumericFieldValue value) {
        if (value instanceof ByteFieldValue) {
            return BigDecimal.valueOf(((ByteFieldValue)value).getByte());
        }
        if (value instanceof DoubleFieldValue) {
            return BigDecimal.valueOf(((DoubleFieldValue)value).getDouble());
        }
        if (value instanceof FloatFieldValue) {
            return BigDecimal.valueOf(((FloatFieldValue)value).getFloat());
        }
        if (value instanceof IntegerFieldValue) {
            return BigDecimal.valueOf(((IntegerFieldValue)value).getInteger());
        }
        if (value instanceof LongFieldValue) {
            return BigDecimal.valueOf(((LongFieldValue)value).getLong());
        }
        throw new IllegalArgumentException("Unsupported numeric field value type '" + value.getClass().getName() + "'");
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        this.left.select(predicate, operation);
        this.right.select(predicate, operation);
    }

    public static enum Operator {
        ADD(1, "+"),
        SUB(1, "-"),
        MUL(0, "*"),
        DIV(0, "/"),
        MOD(0, "%");

        private final int precedence;
        private final String img;

        private Operator(int precedence, String img) {
            this.precedence = precedence;
            this.img = img;
        }

        public boolean precedes(Operator op) {
            return this.precedence <= op.precedence;
        }

        public String toString() {
            return this.img;
        }
    }
}

