/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.text.Text;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class SubstringExpression
extends Expression {
    private final int from;
    private final int to;

    public SubstringExpression(int from, int to) {
        super((DataType)DataType.STRING);
        if (from < 0 || to < 0 || to < from) {
            throw new IndexOutOfBoundsException();
        }
        this.from = from;
        this.to = to;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        String input = String.valueOf(context.getValue());
        String substring = Text.substringByCodepoints((String)input, (int)this.from, (int)this.to);
        context.setValue((FieldValue)new StringFieldValue(substring));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "substring " + this.from + " " + this.to;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SubstringExpression)) {
            return false;
        }
        SubstringExpression rhs = (SubstringExpression)((Object)obj);
        if (this.from != rhs.from) {
            return false;
        }
        return this.to == rhs.to;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + Integer.valueOf(this.from).hashCode() + Integer.valueOf(this.to).hashCode();
    }
}

