/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class FieldValueConverter {
    public final FieldValue convert(FieldValue value) {
        if (value == null) {
            return null;
        }
        if (this.shouldConvert(value)) {
            return this.doConvert(value);
        }
        if (value instanceof Array) {
            return this.convertArray((Array)value);
        }
        if (value instanceof MapFieldValue) {
            return this.convertMap((MapFieldValue<FieldValue, FieldValue>)((MapFieldValue)value));
        }
        if (value instanceof WeightedSet) {
            return this.convertWset((WeightedSet)value);
        }
        if (value instanceof StructuredFieldValue) {
            return this.convertStructured((StructuredFieldValue)value);
        }
        return value;
    }

    private FieldValue convertArray(Array val) {
        LinkedList<FieldValue> next = new LinkedList<FieldValue>();
        DataType nextType = null;
        Iterator it = val.fieldValueIterator();
        while (it.hasNext()) {
            FieldValue prevVal = (FieldValue)it.next();
            FieldValue nextVal = this.convert(prevVal);
            if (nextVal == null) continue;
            if (nextType == null) {
                nextType = nextVal.getDataType();
            } else if (!nextType.isValueCompatible(nextVal)) {
                throw new IllegalArgumentException("Expected " + nextType.getName() + ", got " + nextVal.getDataType().getName());
            }
            next.add(nextVal);
        }
        if (nextType == null) {
            return null;
        }
        Array ret = DataType.getArray(nextType).createFieldValue();
        ret.addAll(next);
        return ret;
    }

    private FieldValue convertMap(MapFieldValue<FieldValue, FieldValue> val) {
        LinkedHashMap<FieldValue, FieldValue> next = new LinkedHashMap<FieldValue, FieldValue>();
        DataType nextKeyType = null;
        DataType nextValType = null;
        for (Map.Entry entry : val.entrySet()) {
            FieldValue prevVal;
            FieldValue nextVal;
            FieldValue prevKey = (FieldValue)entry.getKey();
            FieldValue nextKey = this.convert(prevKey);
            if (nextKey == null) continue;
            if (nextKeyType == null) {
                nextKeyType = nextKey.getDataType();
            } else if (!nextKeyType.isValueCompatible(nextKey)) {
                throw new IllegalArgumentException("Expected " + nextKeyType.getName() + ", got " + nextKey.getDataType().getName());
            }
            if ((nextVal = this.convert(prevVal = (FieldValue)entry.getValue())) == null) continue;
            if (nextValType == null) {
                nextValType = nextVal.getDataType();
            } else if (!nextValType.isValueCompatible(nextVal)) {
                throw new IllegalArgumentException("Expected " + nextValType.getName() + ", got " + nextVal.getDataType().getName());
            }
            next.put(nextKey, nextVal);
        }
        if (nextKeyType == null || nextValType == null) {
            return null;
        }
        MapFieldValue ret = DataType.getMap(nextKeyType, nextValType).createFieldValue();
        ret.putAll(next);
        return ret;
    }

    private FieldValue convertWset(WeightedSet val) {
        LinkedHashMap<FieldValue, Integer> next = new LinkedHashMap<FieldValue, Integer>();
        DataType nextType = null;
        Iterator it = val.fieldValueIterator();
        while (it.hasNext()) {
            FieldValue prevKey = (FieldValue)it.next();
            Integer prevVal = val.get((Object)prevKey);
            FieldValue nextKey = this.convert(prevKey);
            if (nextKey == null) continue;
            if (nextType == null) {
                nextType = nextKey.getDataType();
            } else if (!nextType.isValueCompatible(nextKey)) {
                throw new IllegalArgumentException("Expected " + nextType.getName() + ", got " + nextKey.getDataType().getName());
            }
            next.put(nextKey, prevVal);
        }
        if (nextType == null) {
            return null;
        }
        WeightedSet ret = DataType.getWeightedSet(nextType, (boolean)val.getDataType().createIfNonExistent(), (boolean)val.getDataType().removeIfZero()).createFieldValue();
        ret.putAll(next);
        return ret;
    }

    private FieldValue convertStructured(StructuredFieldValue val) {
        StructuredFieldValue ret = val.getDataType().createFieldValue();
        for (Map.Entry entry : val) {
            FieldValue prev = (FieldValue)entry.getValue();
            FieldValue next = this.convert(prev);
            if (next == null) continue;
            ret.setFieldValue((Field)entry.getKey(), next);
        }
        return ret;
    }

    protected abstract boolean shouldConvert(FieldValue var1);

    protected abstract FieldValue doConvert(FieldValue var1);
}

