/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class GetFieldExpression
extends Expression {
    private final String fieldName;

    public GetFieldExpression(String fieldName) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getValue();
        if (!(input instanceof StructuredFieldValue)) {
            throw new IllegalArgumentException("Expected structured input, got " + input.getDataType().getName());
        }
        StructuredFieldValue struct = (StructuredFieldValue)input;
        Field field = struct.getField(this.fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field '" + this.fieldName + "' not found in struct type '" + struct.getDataType().getName() + "'");
        }
        context.setValue(struct.getFieldValue(field));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValueType();
        if (!(input instanceof StructuredDataType)) {
            throw new VerificationException(this, "Expected structured input, got " + input.getName());
        }
        Field field = ((StructuredDataType)input).getField(this.fieldName);
        if (field == null) {
            throw new VerificationException(this, "Field '" + this.fieldName + "' not found in struct type '" + input.getName() + "'");
        }
        context.setValueType(field.getDataType());
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "get_field " + this.fieldName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GetFieldExpression)) {
            return false;
        }
        GetFieldExpression rhs = (GetFieldExpression)((Object)obj);
        return this.fieldName.equals(rhs.fieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.fieldName.hashCode();
    }
}

