/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class CatExpression
extends ExpressionList<Expression> {
    public CatExpression(Expression ... lst) {
        this(Arrays.asList(lst));
    }

    public CatExpression(Collection<? extends Expression> lst) {
        super(lst, CatExpression.resolveInputType(lst));
    }

    @Override
    public CatExpression convertChildren(ExpressionConverter converter) {
        return new CatExpression(this.convertChildList(converter));
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getValue();
        DataType inputType = input != null ? input.getDataType() : null;
        VerificationContext ver = new VerificationContext(context);
        LinkedList<FieldValue> values = new LinkedList<FieldValue>();
        LinkedList<DataType> types = new LinkedList<DataType>();
        for (Expression exp : this) {
            FieldValue val = context.setValue(input).execute(exp).getValue();
            values.add(val);
            DataType type = val != null ? val.getDataType() : ver.setValueType(inputType).execute(this).getValueType();
            types.add(type);
        }
        DataType type = CatExpression.resolveOutputType(types);
        context.setValue(type == DataType.STRING ? CatExpression.asString(values) : CatExpression.asCollection(type, values));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValueType();
        LinkedList<DataType> types = new LinkedList<DataType>();
        for (Expression exp : this) {
            DataType val = context.setValueType(input).execute(exp).getValueType();
            types.add(val);
            if (val != null) continue;
            throw new VerificationException(this, "Attempting to concatenate a null value (" + exp + ")");
        }
        context.setValueType(CatExpression.resolveOutputType(types));
    }

    private static DataType resolveInputType(Collection<? extends Expression> list) {
        DataType prev = null;
        for (Expression expression : list) {
            DataType next = expression.requiredInputType();
            if (next == null) continue;
            if (prev == null) {
                prev = next;
                continue;
            }
            if (prev.isAssignableFrom(next)) continue;
            throw new VerificationException(CatExpression.class, "Operands require conflicting input types, " + prev.getName() + " vs " + next.getName());
        }
        return prev;
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ret.append(it.next());
            if (!it.hasNext()) continue;
            ret.append(" . ");
        }
        return ret.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof CatExpression;
    }

    private static DataType resolveOutputType(List<DataType> types) {
        DataType ret = null;
        for (DataType type : types) {
            if (!(type instanceof CollectionDataType)) {
                return DataType.STRING;
            }
            if (ret == null) {
                ret = type;
                continue;
            }
            if (ret.isAssignableFrom(type)) continue;
            return DataType.STRING;
        }
        return ret;
    }

    private static FieldValue asString(List<FieldValue> outputs) {
        StringBuilder ret = new StringBuilder();
        for (FieldValue val : outputs) {
            if (val == null) {
                return null;
            }
            ret.append(val.toString());
        }
        return new StringFieldValue(ret.toString());
    }

    private static FieldValue asCollection(DataType type, List<FieldValue> values) {
        if (type instanceof ArrayDataType) {
            return CatExpression.asArray((ArrayDataType)type, values);
        }
        if (type instanceof WeightedSetDataType) {
            return CatExpression.asWset((WeightedSetDataType)type, values);
        }
        throw new UnsupportedOperationException(type.getName());
    }

    private static FieldValue asArray(ArrayDataType arrType, List<FieldValue> values) {
        Array out = arrType.createFieldValue();
        for (FieldValue val : values) {
            if (val == null) continue;
            out.addAll((Collection)((Array)val));
        }
        return out;
    }

    private static FieldValue asWset(WeightedSetDataType wsetType, List<FieldValue> values) {
        WeightedSet out = wsetType.createFieldValue();
        for (FieldValue val : values) {
            if (val == null) continue;
            out.putAll((Map)((WeightedSet)val));
        }
        return out;
    }
}

