/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.time.Instant;

public class ToEpochSecondExpression
extends Expression {
    public ToEpochSecondExpression() {
        super((DataType)DataType.STRING);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        String inputString = String.valueOf(context.getValue());
        long epochTime = Instant.parse(inputString).getEpochSecond();
        context.setValue((FieldValue)new LongFieldValue(epochTime));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.LONG;
    }

    public String toString() {
        return "to_epoch_second";
    }

    public boolean equals(Object obj) {
        return obj instanceof ToEpochSecondExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

