/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class NowExpression
extends Expression {
    private final Timer timer;

    public NowExpression() {
        this(SystemTimer.INSTANCE);
    }

    public NowExpression(Timer timer) {
        super(null);
        this.timer = timer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setValue((FieldValue)new LongFieldValue(this.timer.currentTimeSeconds()));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.LONG;
    }

    public String toString() {
        return "now";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NowExpression)) {
            return false;
        }
        NowExpression rhs = (NowExpression)((Object)obj);
        return this.timer == rhs.timer;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.timer.hashCode();
    }

    private static class SystemTimer
    implements Timer {
        static final Timer INSTANCE = new SystemTimer();

        private SystemTimer() {
        }

        @Override
        public long currentTimeSeconds() {
            return System.currentTimeMillis() / 1000L;
        }
    }

    public static interface Timer {
        public long currentTimeSeconds();
    }
}

