/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ScriptParser;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class StatementExpression
extends ExpressionList<Expression> {
    private final List<String> inputFields = List.copyOf(InputExpression.InputFieldNameExtractor.runOn(this));
    private String outputField;

    public StatementExpression(Expression ... lst) {
        this(Arrays.asList(lst));
    }

    public StatementExpression(Iterable<Expression> lst) {
        this((Iterable<Expression>)StatementExpression.filterList(lst), (Object)null);
    }

    private StatementExpression(Iterable<Expression> list, Object unused) {
        super(list, StatementExpression.resolveInputType(list));
    }

    public List<String> getInputFields() {
        return this.inputFields;
    }

    @Override
    public StatementExpression convertChildren(ExpressionConverter converter) {
        return new StatementExpression(this.asList().stream().map(child -> converter.convert((Expression)((Object)child))).filter(Objects::nonNull).toList());
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        for (Expression expression : this) {
            context.execute(expression);
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        for (Expression expression : this) {
            if (!(expression instanceof OutputExpression)) continue;
            this.outputField = ((OutputExpression)expression).getFieldName();
        }
        if (this.outputField != null) {
            context.setOutputField(this.outputField);
        }
        for (Expression expression : this) {
            context.execute(expression);
        }
    }

    private static DataType resolveInputType(Iterable<Expression> expressions) {
        for (Expression expression : expressions) {
            DataType type = expression.requiredInputType();
            if (type != null) {
                return type;
            }
            type = expression.createdOutputType();
            if (type == null) continue;
            return null;
        }
        return null;
    }

    @Override
    public DataType createdOutputType() {
        int i = this.size();
        while (--i >= 0) {
            DataType type = ((Expression)((Object)this.get(i))).createdOutputType();
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.asList().stream().map(Object::toString).collect(Collectors.joining(" | "));
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof StatementExpression;
    }

    public static StatementExpression fromString(String expression) throws ParseException {
        return StatementExpression.fromString(expression, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse.asMap());
    }

    public static StatementExpression fromString(String expression, Linguistics linguistics, Map<String, Embedder> embedders) throws ParseException {
        return StatementExpression.newInstance(new ScriptParserContext(linguistics, embedders).setInputStream(new IndexingInput(expression)));
    }

    public static StatementExpression newInstance(ScriptParserContext config) throws ParseException {
        return ScriptParser.parseStatement(config);
    }

    private static List<Expression> filterList(Iterable<Expression> lst) {
        LinkedList<Expression> ret = new LinkedList<Expression>();
        for (Expression exp : lst) {
            if (exp instanceof StatementExpression) {
                ret.addAll(StatementExpression.filterList((StatementExpression)exp));
                continue;
            }
            if (exp == null) continue;
            ret.add(exp);
        }
        return ret;
    }
}

