/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.util.Iterator;

public final class JoinExpression
extends Expression {
    private final String delimiter;

    public JoinExpression(String delimiter) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getValue();
        if (!(input instanceof Array)) {
            throw new IllegalArgumentException("Expected Array input, got " + input.getDataType().getName() + ".");
        }
        StringBuilder output = new StringBuilder();
        Iterator it = ((Array)input).fieldValueIterator();
        while (it.hasNext()) {
            output.append(it.next());
            if (!it.hasNext()) continue;
            output.append(this.delimiter);
        }
        context.setValue((FieldValue)new StringFieldValue(output.toString()));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValueType();
        if (!(input instanceof ArrayDataType)) {
            throw new VerificationException(this, "Expected Array input, got " + input.getName() + ".");
        }
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "join \"" + StringUtilities.escape((String)this.delimiter, (char)'\"') + "\"";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinExpression)) {
            return false;
        }
        JoinExpression rhs = (JoinExpression)((Object)obj);
        return this.delimiter.equals(rhs.delimiter);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.delimiter.hashCode();
    }
}

