/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.indexinglanguage.FieldValueConverter;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;

public final class ForEachExpression
extends CompositeExpression {
    private final Expression exp;

    public ForEachExpression(Expression exp) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.exp = exp;
    }

    public Expression getInnerExpression() {
        return this.exp;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        FieldValue input = ctx.getValue();
        if (input instanceof Array || input instanceof WeightedSet) {
            FieldValue next = new MyConverter(ctx, this.exp).convert(input);
            if (next == null) {
                VerificationContext vctx = new VerificationContext(ctx);
                vctx.setValue(input.getDataType()).execute(this);
                next = vctx.getValue().createFieldValue();
            }
            ctx.setValue(next);
        } else if (input instanceof Struct) {
            ctx.setValue(new MyConverter(ctx, this.exp).convert(input));
        } else {
            throw new IllegalArgumentException("Expected Array, Struct or WeightedSet input, got " + input.getDataType().getName() + ".");
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValue();
        if (input instanceof ArrayDataType || input instanceof WeightedSetDataType) {
            context.setValue(((CollectionDataType)input).getNestedType()).execute(this.exp);
            if (input instanceof ArrayDataType) {
                context.setValue((DataType)DataType.getArray((DataType)context.getValue()));
            } else {
                WeightedSetDataType wset = (WeightedSetDataType)input;
                context.setValue((DataType)DataType.getWeightedSet((DataType)context.getValue(), (boolean)wset.createIfNonExistent(), (boolean)wset.removeIfZero()));
            }
        } else if (input instanceof StructDataType) {
            for (Field field : ((StructDataType)input).getFields()) {
                DataType valueType;
                DataType fieldType = field.getDataType();
                if (fieldType.isAssignableFrom(valueType = context.setValue(fieldType).execute(this.exp).getValue())) continue;
                throw new VerificationException(this, "Expected " + fieldType.getName() + " output, got " + valueType.getName() + ".");
            }
            context.setValue(input);
        } else {
            throw new VerificationException(this, "Expected Array, Struct or WeightedSet input, got " + input.getName() + ".");
        }
    }

    @Override
    public DataType createdOutputType() {
        if (this.exp.createdOutputType() == null) {
            return null;
        }
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "for_each { " + this.exp + " }";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ForEachExpression)) {
            return false;
        }
        ForEachExpression rhs = (ForEachExpression)((Object)obj);
        return ((Object)((Object)this.exp)).equals((Object)rhs.exp);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.exp)).hashCode();
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        ForEachExpression.select((Selectable)this.exp, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    private static final class MyConverter
    extends FieldValueConverter {
        final ExecutionContext context;
        final Expression expression;
        int depth = 0;

        MyConverter(ExecutionContext context, Expression expression) {
            this.context = context;
            this.expression = expression;
        }

        @Override
        protected boolean shouldConvert(FieldValue value) {
            return ++this.depth > 1;
        }

        @Override
        protected FieldValue doConvert(FieldValue value) {
            this.context.setValue(value).execute(this.expression);
            return this.context.getValue();
        }
    }
}

