/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Transformer;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class NormalizeExpression
extends Expression {
    private final Linguistics linguistics;

    public NormalizeExpression(Linguistics linguistics) {
        super((DataType)DataType.STRING);
        this.linguistics = linguistics;
    }

    public Linguistics getLinguistics() {
        return this.linguistics;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        Transformer transformer = this.linguistics.getTransformer();
        context.setValue((FieldValue)new StringFieldValue(transformer.accentDrop(String.valueOf(context.getValue()), context.resolveLanguage(this.linguistics))));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "normalize";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NormalizeExpression)) {
            return false;
        }
        NormalizeExpression rhs = (NormalizeExpression)((Object)obj);
        return this.linguistics == rhs.linguistics;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

