/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.FieldPathEntry;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.fieldpathupdate.AddFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.AssignFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.fieldpathupdate.RemoveFieldPathUpdate;

public abstract class FieldPathUpdateHelper {
    public static boolean isComplete(FieldPathUpdate update) {
        if (!(update instanceof AssignFieldPathUpdate)) {
            return false;
        }
        return update.getFieldPath().size() == 1 && update.getFieldPath().get(0).getType() == FieldPathEntry.Type.STRUCT_FIELD;
    }

    public static void applyUpdate(FieldPathUpdate update, Document doc) {
        if (update instanceof AddFieldPathUpdate) {
            update.applyTo(doc);
        } else if (update instanceof AssignFieldPathUpdate) {
            AssignFieldPathUpdate assign = (AssignFieldPathUpdate)update;
            boolean createMissingPath = assign.getCreateMissingPath();
            boolean removeIfZero = assign.getRemoveIfZero();
            assign.setCreateMissingPath(true);
            assign.setRemoveIfZero(false);
            assign.applyTo(doc);
            assign.setCreateMissingPath(createMissingPath);
            assign.setRemoveIfZero(removeIfZero);
        } else if (update instanceof RemoveFieldPathUpdate) {
            doc.iterateNested(update.getFieldPath(), 0, (FieldPathIteratorHandler)new MyHandler());
        }
    }

    public static Document newPartialDocument(DocumentId docId, FieldPathUpdate update) {
        Document doc = new Document(update.getDocumentType(), docId);
        FieldPathUpdateHelper.applyUpdate(update, doc);
        return doc;
    }

    private static class MyHandler
    extends FieldPathIteratorHandler {
        private MyHandler() {
        }

        public FieldPathIteratorHandler.ModificationStatus doModify(FieldValue fv) {
            return FieldPathIteratorHandler.ModificationStatus.MODIFIED;
        }

        public boolean createMissingPath() {
            return true;
        }
    }
}

