/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.vespa.indexinglanguage.ScriptParser;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public final class ScriptExpression
extends ExpressionList<StatementExpression> {
    public ScriptExpression() {
        this(Collections.emptyList());
    }

    public ScriptExpression(StatementExpression ... lst) {
        this(Arrays.asList(lst));
    }

    public ScriptExpression(Collection<? extends StatementExpression> lst) {
        super(lst, ScriptExpression.resolveInputType(lst));
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getValue();
        for (Expression exp : this) {
            context.setValue(input).execute(exp);
        }
        context.setValue(input);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValueType();
        for (Expression exp : this) {
            context.setValueType(input).execute(exp);
        }
        context.setValueType(input);
    }

    private static DataType resolveInputType(Collection<? extends StatementExpression> list) {
        DataType prev = null;
        for (Expression expression : list) {
            DataType next = expression.requiredInputType();
            if (prev == null) {
                prev = next;
                continue;
            }
            if (next == null || prev.isAssignableFrom(next)) continue;
            throw new VerificationException(ScriptExpression.class, "Statements require conflicting input types, " + prev.getName() + " vs " + next.getName() + ".");
        }
        return prev;
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("{ ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ret.append(it.next()).append(";");
            if (!it.hasNext()) continue;
            ret.append(" ");
        }
        ret.append(" }");
        return ret.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof ScriptExpression;
    }

    public static ScriptExpression fromString(String expression) throws ParseException {
        return ScriptExpression.fromString(expression, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse.asMap());
    }

    public static ScriptExpression fromString(String expression, Linguistics linguistics, Map<String, Embedder> embedders) throws ParseException {
        return ScriptExpression.newInstance(new ScriptParserContext(linguistics, embedders).setInputStream(new IndexingInput(expression)));
    }

    public static ScriptExpression newInstance(ScriptParserContext config) throws ParseException {
        return ScriptParser.parseScript(config);
    }
}

