/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.vespa.indexinglanguage.AdapterFactory;
import com.yahoo.vespa.indexinglanguage.DocumentAdapter;
import com.yahoo.vespa.indexinglanguage.ScriptParser;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.SimpleAdapterFactory;
import com.yahoo.vespa.indexinglanguage.UpdateAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypeAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValueAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import com.yahoo.vespa.objects.Selectable;

public abstract class Expression
extends Selectable {
    private final DataType inputType;

    protected Expression(DataType inputType) {
        this.inputType = inputType;
    }

    public void setStatementOutput(DocumentType documentType, Field field) {
    }

    public final FieldValue execute(FieldValue val) {
        return this.execute(new ExecutionContext().setValue(val));
    }

    public final Document execute(AdapterFactory factory, Document doc) {
        return this.execute(factory.newDocumentAdapter(doc));
    }

    public final Document execute(DocumentAdapter adapter) {
        this.execute((FieldValueAdapter)adapter);
        return adapter.getFullOutput();
    }

    public static DocumentUpdate execute(Expression expression, AdapterFactory factory, DocumentUpdate update) {
        DocumentUpdate ret = null;
        for (UpdateAdapter adapter : factory.newUpdateAdapterList(update)) {
            DocumentUpdate output = adapter.getExpression(expression).execute(adapter);
            if (output == null) continue;
            if (ret != null) {
                ret.addAll(output);
                continue;
            }
            ret = output;
        }
        if (ret != null) {
            ret.setCreateIfNonExistent(update.getCreateIfNonExistent());
        }
        return ret;
    }

    public final DocumentUpdate execute(UpdateAdapter adapter) {
        this.execute((FieldValueAdapter)adapter);
        return adapter.getOutput();
    }

    public final FieldValue execute(FieldValueAdapter adapter) {
        return this.execute(new ExecutionContext(adapter));
    }

    public final FieldValue execute(ExecutionContext context) {
        FieldValue output;
        DataType inputType = this.requiredInputType();
        if (inputType != null) {
            FieldValue input = context.getValue();
            if (input == null) {
                return null;
            }
            if (!inputType.isValueCompatible(input)) {
                throw new IllegalArgumentException("Expression '" + this + "' expected " + inputType.getName() + " input, got " + input.getDataType().getName() + ".");
            }
        }
        this.doExecute(context);
        DataType outputType = this.createdOutputType();
        if (outputType != null && (output = context.getValue()) != null && !outputType.isValueCompatible(output)) {
            throw new IllegalStateException("Expression '" + this + "' expected " + outputType.getName() + " output, got " + output.getDataType().getName() + ".");
        }
        return context.getValue();
    }

    protected abstract void doExecute(ExecutionContext var1);

    public final DataType verify() {
        return this.verify(new VerificationContext());
    }

    public final DataType verify(DataType val) {
        return this.verify(new VerificationContext().setValueType(val));
    }

    public final Document verify(Document doc) {
        return this.verify((AdapterFactory)new SimpleAdapterFactory(), doc);
    }

    public final Document verify(AdapterFactory factory, Document doc) {
        return this.verify(factory.newDocumentAdapter(doc));
    }

    public final Document verify(DocumentAdapter adapter) {
        this.verify((FieldTypeAdapter)adapter);
        return adapter.getFullOutput();
    }

    public final DocumentUpdate verify(DocumentUpdate upd) {
        return this.verify((AdapterFactory)new SimpleAdapterFactory(), upd);
    }

    public final DocumentUpdate verify(AdapterFactory factory, DocumentUpdate upd) {
        DocumentUpdate ret = null;
        for (UpdateAdapter adapter : factory.newUpdateAdapterList(upd)) {
            DocumentUpdate output = this.verify(adapter);
            if (output == null) continue;
            if (ret != null) {
                ret.addAll(output);
                continue;
            }
            ret = output;
        }
        return ret;
    }

    public final DocumentUpdate verify(UpdateAdapter adapter) {
        this.verify((FieldTypeAdapter)adapter);
        return adapter.getOutput();
    }

    public final DataType verify(FieldTypeAdapter adapter) {
        return this.verify(new VerificationContext(adapter));
    }

    public final DataType verify(VerificationContext context) {
        if (this.inputType != null) {
            DataType input = context.getValueType();
            if (input == null) {
                throw new VerificationException(this, "Expected " + this.inputType.getName() + " input, got null.");
            }
            if (input.getPrimitiveType() == UnresolvedDataType.INSTANCE) {
                throw new VerificationException(this, "Failed to resolve input type.");
            }
            if (!this.inputType.isAssignableFrom(input)) {
                throw new VerificationException(this, "Expected " + this.inputType.getName() + " input, got " + input.getName() + ".");
            }
        }
        this.doVerify(context);
        DataType outputType = this.createdOutputType();
        if (outputType != null) {
            DataType output = context.getValueType();
            if (output == null) {
                throw new VerificationException(this, "Expected " + outputType.getName() + " output, got null.");
            }
            if (output.getPrimitiveType() == UnresolvedDataType.INSTANCE) {
                throw new VerificationException(this, "Failed to resolve output type.");
            }
            if (!outputType.isAssignableFrom(output)) {
                throw new VerificationException(this, "Expected " + outputType.getName() + " output, got " + output.getName() + ".");
            }
        }
        return context.getValueType();
    }

    protected abstract void doVerify(VerificationContext var1);

    public final DataType requiredInputType() {
        return this.inputType;
    }

    public abstract DataType createdOutputType();

    public static Expression fromString(String expression) throws ParseException {
        return Expression.fromString(expression, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse);
    }

    public static Expression fromString(String expression, Linguistics linguistics, Embedder embedder) throws ParseException {
        return Expression.newInstance(new ScriptParserContext(linguistics, embedder).setInputStream(new IndexingInput(expression)));
    }

    public static Expression newInstance(ScriptParserContext context) throws ParseException {
        return ScriptParser.parseExpression(context);
    }

    protected static boolean equals(Object lhs, Object rhs) {
        if (lhs == null) {
            if (rhs != null) {
                return false;
            }
        } else {
            if (rhs == null) {
                return false;
            }
            if (!lhs.equals(rhs)) {
                return false;
            }
        }
        return true;
    }

    public static Document execute(Expression expression, Document doc) {
        return expression.execute(new SimpleAdapterFactory(), doc);
    }

    public static DocumentUpdate execute(Expression expression, DocumentUpdate update) {
        return Expression.execute(expression, new SimpleAdapterFactory(), update);
    }

    public final FieldValue execute() {
        return this.execute(new ExecutionContext());
    }
}

