/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.Base64;

public final class Base64DecodeExpression
extends Expression {
    public Base64DecodeExpression() {
        super((DataType)DataType.STRING);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        String input = String.valueOf(context.getValue());
        if (input.isEmpty()) {
            context.setValue((FieldValue)new LongFieldValue(Long.MIN_VALUE));
            return;
        }
        if (input.length() > 12) {
            throw new NumberFormatException("Base64 value '" + input + "' is out of range.");
        }
        byte[] decoded = Base64.getDecoder().decode(input);
        if (decoded == null || decoded.length == 0) {
            throw new NumberFormatException("Illegal base64 value '" + input + "'.");
        }
        long output = 0L;
        int i = decoded.length;
        while (--i >= 0) {
            output = (output << 8) + (long)(decoded[i] & 0xFF);
        }
        context.setValue((FieldValue)new LongFieldValue(output));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.LONG;
    }

    public String toString() {
        return "base64decode";
    }

    public boolean equals(Object obj) {
        return obj instanceof Base64DecodeExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

