/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypeAdapter;
import java.util.HashMap;
import java.util.Map;

public class VerificationContext
implements FieldTypeAdapter,
Cloneable {
    private final Map<String, DataType> variables = new HashMap<String, DataType>();
    private final FieldTypeAdapter adapter;
    private DataType value;

    public VerificationContext() {
        this.adapter = null;
    }

    public VerificationContext(FieldTypeAdapter adapter) {
        this.adapter = adapter;
    }

    public VerificationContext execute(Expression exp) {
        if (exp != null) {
            exp.verify(this);
        }
        return this;
    }

    @Override
    public DataType getInputType(Expression exp, String fieldName) {
        return this.adapter.getInputType(exp, fieldName);
    }

    @Override
    public void tryOutputType(Expression exp, String fieldName, DataType valueType) {
        this.adapter.tryOutputType(exp, fieldName, valueType);
    }

    public DataType getVariable(String name) {
        return this.variables.get(name);
    }

    public VerificationContext setVariable(String name, DataType value) {
        this.variables.put(name, value);
        return this;
    }

    public DataType getValue() {
        return this.value;
    }

    public VerificationContext setValue(DataType value) {
        this.value = value;
        return this;
    }

    public VerificationContext clear() {
        this.variables.clear();
        this.value = null;
        return this;
    }
}

