/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class HostNameExpression
extends Expression {
    public HostNameExpression() {
        super(null);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setValue((FieldValue)new StringFieldValue(HostNameExpression.normalizeHostName(Defaults.getDefaults().vespaHostname())));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "hostname";
    }

    public boolean equals(Object obj) {
        return obj instanceof HostNameExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public static String normalizeHostName(String hostName) {
        int pos = hostName.indexOf(46);
        return pos < 0 ? hostName : hostName.substring(0, pos);
    }
}

