/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class ToBoolExpression
extends Expression {
    public ToBoolExpression() {
        super((DataType)UnresolvedDataType.INSTANCE);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setValue((FieldValue)new BoolFieldValue(this.toBooleanValue(context.getValue())));
    }

    private boolean toBooleanValue(FieldValue value) {
        if (value instanceof NumericFieldValue) {
            return ((NumericFieldValue)value).getNumber().intValue() != 0;
        }
        if (value instanceof StringFieldValue) {
            return !((StringFieldValue)value).getString().isEmpty();
        }
        return false;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.BOOL;
    }

    public String toString() {
        return "to_bool";
    }

    public boolean equals(Object obj) {
        return obj instanceof ToBoolExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

