/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.collections.Pair;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SelectInputExpression
extends CompositeExpression {
    private final List<Pair<String, Expression>> cases;

    @SafeVarargs
    public SelectInputExpression(Pair<String, Expression> ... cases) {
        this(Arrays.asList(cases));
    }

    public SelectInputExpression(List<Pair<String, Expression>> cases) {
        super(null);
        this.cases = cases;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        FieldValue input = ctx.getValue();
        for (Pair<String, Expression> entry : this.cases) {
            FieldValue val = ctx.getInputValue((String)entry.getFirst());
            if (val == null) continue;
            ctx.setValue(val).execute((Expression)((Object)entry.getSecond()));
            break;
        }
        ctx.setValue(input);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValue();
        for (Pair<String, Expression> entry : this.cases) {
            DataType val = context.getInputType(this, (String)entry.getFirst());
            if (val == null) {
                throw new VerificationException(this, "Field '" + (String)entry.getFirst() + "' not found.");
            }
            context.setValue(val).execute((Expression)((Object)entry.getSecond()));
        }
        context.setValue(input);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        for (Pair<String, Expression> entry : this.cases) {
            SelectInputExpression.select((Selectable)((Selectable)entry.getSecond()), (ObjectPredicate)predicate, (ObjectOperation)operation);
        }
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public List<Pair<String, Expression>> getCases() {
        return Collections.unmodifiableList(this.cases);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("select_input { ");
        for (Pair<String, Expression> entry : this.cases) {
            ret.append((String)entry.getFirst()).append(": ");
            Expression exp = (Expression)((Object)entry.getSecond());
            ret.append((Object)exp).append("; ");
        }
        ret.append("}");
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SelectInputExpression)) {
            return false;
        }
        SelectInputExpression rhs = (SelectInputExpression)((Object)obj);
        return this.cases.equals(rhs.cases);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.cases.hashCode();
    }
}

