/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.StemMode;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import com.yahoo.vespa.indexinglanguage.linguistics.LinguisticsAnnotator;

public final class TokenizeExpression
extends Expression {
    private final Linguistics linguistics;
    private final AnnotatorConfig config;

    public TokenizeExpression(Linguistics linguistics, AnnotatorConfig config) {
        super((DataType)DataType.STRING);
        this.linguistics = linguistics;
        this.config = config;
    }

    public Linguistics getLinguistics() {
        return this.linguistics;
    }

    public AnnotatorConfig getConfig() {
        return this.config;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        StringFieldValue input = (StringFieldValue)context.getValue();
        StringFieldValue output = input.clone();
        context.setValue((FieldValue)output);
        AnnotatorConfig cfg = new AnnotatorConfig(this.config);
        Language lang = context.resolveLanguage(this.linguistics);
        if (lang != null) {
            cfg.setLanguage(lang);
        }
        LinguisticsAnnotator annotator = new LinguisticsAnnotator(this.linguistics, cfg);
        annotator.annotate(output);
    }

    @Override
    protected void doVerify(VerificationContext context) {
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("tokenize");
        if (this.config.getRemoveAccents()) {
            ret.append(" normalize");
        }
        if (this.config.getStemMode() != StemMode.NONE) {
            ret.append(" stem:\"" + this.config.getStemMode() + "\"");
        }
        if (this.config.hasNonDefaultMaxTokenLength()) {
            ret.append(" max-length:" + this.config.getMaxTokenizeLength());
        }
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TokenizeExpression)) {
            return false;
        }
        TokenizeExpression rhs = (TokenizeExpression)((Object)obj);
        return this.config.equals(rhs.config);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.config.hashCode();
    }
}

