/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomExpression
extends Expression {
    private final Integer max;

    public RandomExpression() {
        this((Integer)null);
    }

    public RandomExpression(Integer max) {
        super(null);
        this.max = max;
    }

    public Integer getMaxValue() {
        return this.max;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        int max = this.max != null ? this.max : Integer.parseInt(String.valueOf(ctx.getValue()));
        ctx.setValue((FieldValue)new IntegerFieldValue(ThreadLocalRandom.current().nextInt(max)));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.INT;
    }

    public String toString() {
        return "random" + (String)(this.max != null ? " " + this.max : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RandomExpression)) {
            return false;
        }
        RandomExpression rhs = (RandomExpression)((Object)obj);
        return RandomExpression.equals(this.max, rhs.max);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

