/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.vespa.indexinglanguage.expressions.ArithmeticExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class MathResolver {
    private final List<Item> items = new LinkedList<Item>();

    public void push(ArithmeticExpression.Operator op, Expression exp) {
        ((Object)((Object)op)).getClass();
        if (this.items.isEmpty() && op != ArithmeticExpression.Operator.ADD) {
            throw new IllegalArgumentException("First item in an arithmetic operation must be an addition.");
        }
        this.items.add(new Item(op, exp));
    }

    public Expression resolve() {
        Stack<Item> stack = new Stack<Item>();
        stack.push(this.items.remove(0));
        while (!this.items.isEmpty()) {
            Item item = this.items.remove(0);
            while (stack.size() > 1 && stack.peek().op.precedes(item.op)) {
                this.pop(stack);
            }
            stack.push(item);
        }
        while (stack.size() > 1) {
            this.pop(stack);
        }
        return ((Item)stack.remove((int)0)).exp;
    }

    private void pop(Stack<Item> stack) {
        Item rhs = stack.pop();
        Item lhs = stack.peek();
        lhs.exp = new ArithmeticExpression(lhs.exp, rhs.op, rhs.exp);
    }

    private static class Item {
        final ArithmeticExpression.Operator op;
        Expression exp;

        Item(ArithmeticExpression.Operator op, Expression exp) {
            this.op = op;
            this.exp = exp;
        }
    }
}

