/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class FlattenExpression
extends Expression {
    public FlattenExpression() {
        super((DataType)DataType.STRING);
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        StringFieldValue input = (StringFieldValue)ctx.getValue();
        SpanTree tree = input.getSpanTree("linguistics");
        HashMap<Integer, LinkedList<String>> map = new HashMap<Integer, LinkedList<String>>();
        for (Annotation anno : tree) {
            SpanNode span = anno.getSpanNode();
            if (span == null || anno.getType() != AnnotationTypes.TERM) continue;
            FieldValue val = anno.getFieldValue();
            String str = val instanceof StringFieldValue ? ((StringFieldValue)val).getString() : input.getString().substring(span.getFrom(), span.getTo());
            Integer pos = span.getTo();
            LinkedList<String> entry = (LinkedList<String>)map.get(pos);
            if (entry == null) {
                entry = new LinkedList<String>();
                map.put(pos, entry);
            }
            entry.add(str);
        }
        String inputVal = String.valueOf(input);
        StringBuilder output = new StringBuilder();
        int len = inputVal.length();
        for (int i = 0; i <= len; ++i) {
            List entry = (List)map.get(i);
            if (entry != null) {
                Collections.sort(entry);
                output.append(entry);
            }
            if (i >= len) continue;
            output.append(inputVal.charAt(i));
        }
        ctx.setValue((FieldValue)new StringFieldValue(output.toString()));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "flatten";
    }

    public boolean equals(Object obj) {
        return obj instanceof FlattenExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

