/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.math.BigDecimal;
import java.math.MathContext;

public final class ArithmeticExpression
extends CompositeExpression {
    private final Expression lhs;
    private final Operator op;
    private final Expression rhs;

    public ArithmeticExpression(Expression lhs, Operator op, Expression rhs) {
        super(ArithmeticExpression.requiredInputType(lhs, rhs));
        ((Object)((Object)lhs)).getClass();
        ((Object)((Object)op)).getClass();
        ((Object)((Object)rhs)).getClass();
        this.lhs = lhs;
        this.op = op;
        this.rhs = rhs;
    }

    public Expression getLeftHandSide() {
        return this.lhs;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getRightHandSide() {
        return this.rhs;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        FieldValue input = ctx.getValue();
        ctx.setValue(this.evaluate(ctx.setValue(input).execute(this.lhs).getValue(), ctx.setValue(input).execute(this.rhs).getValue()));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValue();
        context.setValue(this.evaluate(context.setValue(input).execute(this.lhs).getValue(), context.setValue(input).execute(this.rhs).getValue()));
    }

    private static DataType requiredInputType(Expression lhs, Expression rhs) {
        DataType lhsType = lhs.requiredInputType();
        DataType rhsType = rhs.requiredInputType();
        if (lhsType == null) {
            return rhsType;
        }
        if (rhsType == null) {
            return lhsType;
        }
        if (!lhsType.equals((Object)rhsType)) {
            throw new VerificationException(ArithmeticExpression.class, "Operands require conflicting input types, " + lhsType.getName() + " vs " + rhsType.getName() + ".");
        }
        return lhsType;
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return this.lhs + " " + this.op + " " + this.rhs;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArithmeticExpression)) {
            return false;
        }
        ArithmeticExpression exp = (ArithmeticExpression)((Object)obj);
        if (!((Object)((Object)this.lhs)).equals((Object)exp.lhs)) {
            return false;
        }
        if (!this.op.equals((Object)exp.op)) {
            return false;
        }
        return ((Object)((Object)this.rhs)).equals((Object)exp.rhs);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.lhs)).hashCode() + this.op.hashCode() + ((Object)((Object)this.rhs)).hashCode();
    }

    private DataType evaluate(DataType lhs, DataType rhs) {
        if (lhs == null || rhs == null) {
            throw new VerificationException(this, "Attempting to perform arithmetic on a null value.");
        }
        if (!(lhs instanceof NumericDataType) || !(rhs instanceof NumericDataType)) {
            throw new VerificationException(this, "Attempting to perform unsupported arithmetic: [" + lhs.getName() + "] " + this.op + " [" + rhs.getName() + "]");
        }
        if (lhs == DataType.FLOAT || lhs == DataType.DOUBLE || rhs == DataType.FLOAT || rhs == DataType.DOUBLE) {
            if (lhs == DataType.DOUBLE || rhs == DataType.DOUBLE) {
                return DataType.DOUBLE;
            }
            return DataType.FLOAT;
        }
        if (lhs == DataType.LONG || rhs == DataType.LONG) {
            return DataType.LONG;
        }
        return DataType.INT;
    }

    private FieldValue evaluate(FieldValue lhs, FieldValue rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (!(lhs instanceof NumericFieldValue) || !(rhs instanceof NumericFieldValue)) {
            throw new IllegalArgumentException("Unsupported operation: [" + lhs.getDataType().getName() + "] " + this.op + " [" + rhs.getDataType().getName() + "]");
        }
        BigDecimal lhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)lhs);
        BigDecimal rhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)rhs);
        switch (this.op) {
            case ADD: {
                return this.createFieldValue(lhs, rhs, lhsVal.add(rhsVal));
            }
            case SUB: {
                return this.createFieldValue(lhs, rhs, lhsVal.subtract(rhsVal));
            }
            case MUL: {
                return this.createFieldValue(lhs, rhs, lhsVal.multiply(rhsVal));
            }
            case DIV: {
                return this.createFieldValue(lhs, rhs, lhsVal.divide(rhsVal, MathContext.DECIMAL64));
            }
            case MOD: {
                return this.createFieldValue(lhs, rhs, lhsVal.remainder(rhsVal));
            }
        }
        throw new IllegalStateException("Unsupported operation: " + this.op);
    }

    private FieldValue createFieldValue(FieldValue lhs, FieldValue rhs, BigDecimal val) {
        if (lhs instanceof FloatFieldValue || lhs instanceof DoubleFieldValue || rhs instanceof FloatFieldValue || rhs instanceof DoubleFieldValue) {
            if (lhs instanceof DoubleFieldValue || rhs instanceof DoubleFieldValue) {
                return new DoubleFieldValue(val.doubleValue());
            }
            return new FloatFieldValue(val.floatValue());
        }
        if (lhs instanceof LongFieldValue || rhs instanceof LongFieldValue) {
            return new LongFieldValue(val.longValue());
        }
        return new IntegerFieldValue(val.intValue());
    }

    public static BigDecimal asBigDecimal(NumericFieldValue value) {
        if (value instanceof ByteFieldValue) {
            return BigDecimal.valueOf(((ByteFieldValue)value).getByte());
        }
        if (value instanceof DoubleFieldValue) {
            return BigDecimal.valueOf(((DoubleFieldValue)value).getDouble());
        }
        if (value instanceof FloatFieldValue) {
            return BigDecimal.valueOf(((FloatFieldValue)value).getFloat());
        }
        if (value instanceof IntegerFieldValue) {
            return BigDecimal.valueOf(((IntegerFieldValue)value).getInteger());
        }
        if (value instanceof LongFieldValue) {
            return BigDecimal.valueOf(((LongFieldValue)value).getLong());
        }
        throw new IllegalArgumentException("Unsupported numeric field value type '" + value.getClass().getName() + "'.");
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        this.lhs.select(predicate, operation);
        this.rhs.select(predicate, operation);
    }

    public static enum Operator {
        ADD(1, "+"),
        SUB(1, "-"),
        MUL(0, "*"),
        DIV(0, "/"),
        MOD(0, "%");

        private final int precedence;
        private final String img;

        private Operator(int precedence, String img) {
            this.precedence = precedence;
            this.img = img;
        }

        public boolean precedes(Operator op) {
            return this.precedence <= op.precedence;
        }

        public String toString() {
            return this.img;
        }
    }
}

