/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public class SubstringExpression
extends Expression {
    private final int from;
    private final int to;

    public SubstringExpression(int from, int to) {
        if (from < 0 || to < 0 || to < from) {
            throw new IndexOutOfBoundsException();
        }
        this.from = from;
        this.to = to;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        String input = String.valueOf(ctx.getValue());
        int len = input.length();
        input = this.from >= len ? "" : (this.to >= len ? input.substring(this.from) : input.substring(this.from, this.to));
        ctx.setValue((FieldValue)new StringFieldValue(input));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue(this.createdOutputType());
    }

    @Override
    public DataType requiredInputType() {
        return DataType.STRING;
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "substring " + this.from + " " + this.to;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SubstringExpression)) {
            return false;
        }
        SubstringExpression rhs = (SubstringExpression)((Object)obj);
        if (this.from != rhs.from) {
            return false;
        }
        return this.to == rhs.to;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + Integer.valueOf(this.from).hashCode() + Integer.valueOf(this.to).hashCode();
    }
}

