/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.io.PrintStream;

public class EchoExpression
extends Expression {
    private final PrintStream out;

    public EchoExpression() {
        this(System.out);
    }

    public EchoExpression(PrintStream out) {
        this.out = out;
    }

    public PrintStream getOutputStream() {
        return this.out;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        this.out.println(String.valueOf(ctx.getValue()));
    }

    @Override
    protected void doVerify(VerificationContext context) {
    }

    @Override
    public DataType requiredInputType() {
        return UnresolvedDataType.INSTANCE;
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return "echo";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EchoExpression)) {
            return false;
        }
        EchoExpression rhs = (EchoExpression)((Object)obj);
        return this.out == rhs.out;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.out.hashCode();
    }
}

