/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ArithmeticExpression;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;
import java.math.BigDecimal;

public class IfThenExpression
extends CompositeExpression {
    private final Expression lhs;
    private final Comparator cmp;
    private final Expression rhs;
    private final Expression ifTrue;
    private final Expression ifFalse;

    public IfThenExpression(Expression lhs, Comparator cmp, Expression rhs, Expression ifTrue) {
        this(lhs, cmp, rhs, ifTrue, null);
    }

    public IfThenExpression(Expression lhs, Comparator cmp, Expression rhs, Expression ifTrue, Expression ifFalse) {
        this.lhs = lhs;
        this.cmp = cmp;
        this.rhs = rhs;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    public Expression getLeftHandSide() {
        return this.lhs;
    }

    public Comparator getComparator() {
        return this.cmp;
    }

    public Expression getRightHandSide() {
        return this.rhs;
    }

    public Expression getIfTrueExpression() {
        return this.ifTrue;
    }

    public Expression getIfFalseExpression() {
        return this.ifFalse;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        FieldValue input = ctx.getValue();
        FieldValue lhsVal = ctx.setValue(input).execute(this.lhs).getValue();
        if (lhsVal == null) {
            ctx.setValue(null);
            return;
        }
        FieldValue rhsVal = ctx.setValue(input).execute(this.rhs).getValue();
        if (rhsVal == null) {
            ctx.setValue(null);
            return;
        }
        ctx.setValue(input);
        if (IfThenExpression.isTrue(lhsVal, this.cmp, rhsVal)) {
            this.ifTrue.execute(ctx);
        } else if (this.ifFalse != null) {
            this.ifFalse.execute(ctx);
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValue();
        context.setValue(input).execute(this.lhs);
        context.setValue(input).execute(this.rhs);
        context.setValue(input).execute(this.ifTrue);
        context.setValue(input).execute(this.ifFalse);
        context.setValue(input);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        IfThenExpression.select((Selectable)this.lhs, (ObjectPredicate)predicate, (ObjectOperation)operation);
        IfThenExpression.select((Selectable)this.rhs, (ObjectPredicate)predicate, (ObjectOperation)operation);
        IfThenExpression.select((Selectable)this.ifTrue, (ObjectPredicate)predicate, (ObjectOperation)operation);
        IfThenExpression.select((Selectable)this.ifFalse, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    @Override
    public DataType requiredInputType() {
        DataType input = null;
        input = this.resolveRequiredInputType(input, this.lhs.requiredInputType());
        input = this.resolveRequiredInputType(input, this.rhs.requiredInputType());
        input = this.resolveRequiredInputType(input, this.ifTrue.requiredInputType());
        if (this.ifFalse != null) {
            input = this.resolveRequiredInputType(input, this.ifFalse.requiredInputType());
        }
        return input;
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("if (").append((Object)this.lhs).append(" ").append((Object)this.cmp).append(" ").append((Object)this.rhs).append(") ");
        ret.append(IfThenExpression.toScriptBlock(this.ifTrue));
        if (this.ifFalse != null) {
            ret.append(" else ").append(IfThenExpression.toScriptBlock(this.ifFalse));
        }
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IfThenExpression)) {
            return false;
        }
        IfThenExpression exp = (IfThenExpression)((Object)obj);
        if (!((Object)((Object)this.lhs)).equals((Object)exp.lhs)) {
            return false;
        }
        if (!this.cmp.equals((Object)exp.cmp)) {
            return false;
        }
        if (!((Object)((Object)this.rhs)).equals((Object)exp.rhs)) {
            return false;
        }
        if (!((Object)((Object)this.ifTrue)).equals((Object)exp.ifTrue)) {
            return false;
        }
        return IfThenExpression.equals((Object)this.ifFalse, (Object)exp.ifFalse);
    }

    public int hashCode() {
        int ret = ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.lhs)).hashCode() + this.cmp.hashCode() + ((Object)((Object)this.rhs)).hashCode() + ((Object)((Object)this.ifTrue)).hashCode();
        if (this.ifFalse != null) {
            ret += ((Object)((Object)this.ifFalse)).hashCode();
        }
        return ret;
    }

    private DataType resolveRequiredInputType(DataType prev, DataType next) {
        if (next == null) {
            return prev;
        }
        if (prev == null) {
            return next;
        }
        if (!prev.equals((Object)next)) {
            throw new VerificationException(this, "Operands require conflicting input types, " + prev.getName() + " vs " + next.getName() + ".");
        }
        return prev;
    }

    private static boolean isTrue(FieldValue lhs, Comparator cmp, FieldValue rhs) {
        int res;
        if (lhs instanceof NumericFieldValue && rhs instanceof NumericFieldValue) {
            BigDecimal lhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)lhs);
            BigDecimal rhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)rhs);
            res = lhsVal.compareTo(rhsVal);
        } else {
            res = lhs.compareTo(rhs);
        }
        switch (cmp) {
            case EQ: {
                return res == 0;
            }
            case NE: {
                return res != 0;
            }
            case GT: {
                return res > 0;
            }
            case GE: {
                return res >= 0;
            }
            case LT: {
                return res < 0;
            }
            case LE: {
                return res <= 0;
            }
        }
        throw new UnsupportedOperationException(cmp.toString());
    }

    public static enum Comparator {
        EQ("=="),
        NE("!="),
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">=");

        private final String img;

        private Comparator(String img) {
            this.img = img;
        }

        public String toString() {
            return this.img;
        }
    }
}

