/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.GramSplitter;
import com.yahoo.language.process.TokenType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.linguistics.LinguisticsAnnotator;

public class NGramExpression
extends Expression {
    private final Linguistics linguistics;
    private final int gramSize;

    public NGramExpression(Linguistics linguistics, int gramSize) {
        this.linguistics = linguistics;
        this.gramSize = gramSize;
    }

    public Linguistics getLinguistics() {
        return this.linguistics;
    }

    public int getGramSize() {
        return this.gramSize;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        StringFieldValue input = (StringFieldValue)ctx.getValue();
        SpanList spanList = input.setSpanTree(new SpanTree("linguistics")).spanList();
        int lastPosition = 0;
        GramSplitter.GramSplitterIterator it = this.linguistics.getGramSplitter().split(input.getString(), this.gramSize);
        while (it.hasNext()) {
            GramSplitter.Gram gram = (GramSplitter.Gram)it.next();
            if (lastPosition < gram.getStart()) {
                this.typedSpan(lastPosition, gram.getStart() - lastPosition, TokenType.PUNCTUATION, spanList);
            }
            String gramString = gram.extractFrom(input.getString());
            this.typedSpan(gram.getStart(), gram.getLength(), TokenType.ALPHABETIC, spanList).annotate(LinguisticsAnnotator.lowerCaseTermAnnotation(gramString, gramString));
            lastPosition = gram.getStart() + gram.getLength();
        }
        if (lastPosition < input.toString().length()) {
            this.typedSpan(lastPosition, input.toString().length() - lastPosition, TokenType.PUNCTUATION, spanList);
        }
    }

    private Span typedSpan(int from, int length, TokenType tokenType, SpanList spanList) {
        return (Span)spanList.span(from, length).annotate(AnnotationTypes.TOKEN_TYPE, Integer.valueOf(tokenType.getValue()));
    }

    @Override
    protected void doVerify(VerificationContext context) {
    }

    @Override
    public DataType requiredInputType() {
        return DataType.STRING;
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return "ngram " + this.gramSize;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NGramExpression)) {
            return false;
        }
        NGramExpression rhs = (NGramExpression)((Object)obj);
        if (this.linguistics != rhs.linguistics) {
            return false;
        }
        return this.gramSize == rhs.gramSize;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.gramSize;
    }
}

