/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import org.apache.commons.codec.binary.Base64;

public class Base64DecodeExpression
extends Expression {
    @Override
    protected void doExecute(ExecutionContext ctx) {
        String input = String.valueOf(ctx.getValue());
        if (input.isEmpty()) {
            ctx.setValue((FieldValue)new LongFieldValue(Long.MIN_VALUE));
            return;
        }
        if (input.length() > 12) {
            throw new NumberFormatException("Base64 value '" + input + "' is out of range.");
        }
        byte[] decoded = Base64.decodeBase64((String)input);
        if (decoded == null || decoded.length == 0) {
            throw new NumberFormatException("Illegal base64 value '" + input + "'.");
        }
        long output = 0L;
        int i = decoded.length;
        while (--i >= 0) {
            output = (output << 8) + (long)(decoded[i] & 0xFF);
        }
        ctx.setValue((FieldValue)new LongFieldValue(output));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue(this.createdOutputType());
    }

    @Override
    public DataType requiredInputType() {
        return DataType.STRING;
    }

    @Override
    public DataType createdOutputType() {
        return DataType.LONG;
    }

    public String toString() {
        return "base64decode";
    }

    public boolean equals(Object obj) {
        return obj instanceof Base64DecodeExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

