/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CatExpression
extends ExpressionList<Expression> {
    public CatExpression(Expression ... lst) {
        super(Arrays.asList(lst));
    }

    public CatExpression(Collection<? extends Expression> lst) {
        super(lst);
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        FieldValue input = ctx.getValue();
        DataType inputType = input != null ? input.getDataType() : null;
        VerificationContext ver = new VerificationContext(ctx);
        LinkedList<FieldValue> values = new LinkedList<FieldValue>();
        LinkedList<DataType> types = new LinkedList<DataType>();
        for (Expression exp : this) {
            FieldValue val = ctx.setValue(input).execute(exp).getValue();
            values.add(val);
            DataType type = val != null ? val.getDataType() : ver.setValue(inputType).execute(this).getValue();
            types.add(type);
        }
        DataType type = CatExpression.resolveOutputType(types);
        ctx.setValue(type == DataType.STRING ? CatExpression.asString(values) : CatExpression.asCollection(type, values));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValue();
        LinkedList<DataType> types = new LinkedList<DataType>();
        for (Expression exp : this) {
            DataType val = context.setValue(input).execute(exp).getValue();
            types.add(val);
            if (val != null) continue;
            throw new VerificationException(this, "Attempting to concatenate a null value (" + (Object)((Object)exp) + ").");
        }
        context.setValue(CatExpression.resolveOutputType(types));
    }

    @Override
    public DataType requiredInputType() {
        DataType prev = null;
        for (Expression exp : this) {
            DataType next = exp.requiredInputType();
            if (next == null) continue;
            if (prev == null) {
                prev = next;
                continue;
            }
            if (prev.isAssignableFrom(next)) continue;
            throw new VerificationException(this, "Operands require conflicting input types, " + prev.getName() + " vs " + next.getName() + ".");
        }
        return prev;
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ret.append(it.next());
            if (!it.hasNext()) continue;
            ret.append(" . ");
        }
        return ret.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof CatExpression;
    }

    private static DataType resolveOutputType(List<DataType> types) {
        DataType ret = null;
        for (DataType type : types) {
            if (!(type instanceof CollectionDataType)) {
                return DataType.STRING;
            }
            if (ret == null) {
                ret = type;
                continue;
            }
            if (ret.isAssignableFrom(type)) continue;
            return DataType.STRING;
        }
        return ret;
    }

    private static FieldValue asString(List<FieldValue> outputs) {
        StringBuilder ret = new StringBuilder();
        for (FieldValue val : outputs) {
            if (val == null) {
                return null;
            }
            ret.append(val.toString());
        }
        return new StringFieldValue(ret.toString());
    }

    private static FieldValue asCollection(DataType type, List<FieldValue> values) {
        if (type instanceof ArrayDataType) {
            return CatExpression.asArray((ArrayDataType)type, values);
        }
        if (type instanceof WeightedSetDataType) {
            return CatExpression.asWset((WeightedSetDataType)type, values);
        }
        throw new UnsupportedOperationException(type.getName());
    }

    private static FieldValue asArray(ArrayDataType arrType, List<FieldValue> values) {
        Array out = arrType.createFieldValue();
        for (FieldValue val : values) {
            if (val == null) continue;
            out.addAll((Collection)((Array)val));
        }
        return out;
    }

    private static FieldValue asWset(WeightedSetDataType wsetType, List<FieldValue> values) {
        WeightedSet out = wsetType.createFieldValue();
        for (FieldValue val : values) {
            if (val == null) continue;
            out.putAll((Map)((WeightedSet)val));
        }
        return out;
    }
}

