/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.util.http.hc5;

import ai.vespa.util.http.hc5.HttpToHttpsRoutePlanner;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TransportSecurityUtils;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;

public class VespaHttpClientBuilder {
    public static HttpClientBuilder create() {
        return VespaHttpClientBuilder.create(PoolingHttpClientConnectionManager::new);
    }

    public static HttpClientBuilder create(HttpClientConnectionManagerFactory connectionManagerFactory) {
        return VespaHttpClientBuilder.create(connectionManagerFactory, (HostnameVerifier)new NoopHostnameVerifier());
    }

    public static HttpClientBuilder create(HttpClientConnectionManagerFactory connectionManagerFactory, HostnameVerifier hostnameVerifier) {
        return VespaHttpClientBuilder.create(connectionManagerFactory, hostnameVerifier, true);
    }

    public static HttpClientBuilder create(HttpClientConnectionManagerFactory connectionManagerFactory, HostnameVerifier hostnameVerifier, boolean rewriteHttpToHttps) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        VespaHttpClientBuilder.addSslSocketFactory(builder, connectionManagerFactory, hostnameVerifier);
        if (rewriteHttpToHttps) {
            VespaHttpClientBuilder.addHttpsRewritingRoutePlanner(builder);
        }
        builder.disableConnectionState();
        builder.disableCookieManagement();
        builder.disableAuthCaching();
        builder.disableRedirectHandling();
        return builder;
    }

    private static void addSslSocketFactory(HttpClientBuilder builder, HttpClientConnectionManagerFactory connectionManagerFactory, HostnameVerifier hostnameVerifier) {
        TransportSecurityUtils.getSystemTlsContext().ifPresent(tlsContext -> {
            SSLParameters parameters = tlsContext.parameters();
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(tlsContext.context(), parameters.getProtocols(), parameters.getCipherSuites(), hostnameVerifier);
            builder.setConnectionManager(connectionManagerFactory.create(VespaHttpClientBuilder.createRegistry(socketFactory)));
            builder.setUserTokenHandler((route, context) -> null);
        });
    }

    private static Registry<ConnectionSocketFactory> createRegistry(SSLConnectionSocketFactory sslSocketFactory) {
        return RegistryBuilder.create().register("https", (Object)sslSocketFactory).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }

    private static void addHttpsRewritingRoutePlanner(HttpClientBuilder builder) {
        if (TransportSecurityUtils.isTransportSecurityEnabled() && TransportSecurityUtils.getInsecureMixedMode() != MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
            builder.setRoutePlanner((HttpRoutePlanner)new HttpToHttpsRoutePlanner());
        }
    }

    public static interface HttpClientConnectionManagerFactory {
        public HttpClientConnectionManager create(Registry<ConnectionSocketFactory> var1);
    }
}

