/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.client;

import ai.vespa.hosted.client.AbstractHttpClient;
import ai.vespa.http.HttpURL;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;

public class MockHttpClient
extends AbstractHttpClient {
    private final Deque<Expectation> expectations = new ArrayDeque<Expectation>();

    @Override
    protected ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientContext context) throws IOException {
        Expectation expectation = this.expectations.poll();
        if (expectation == null) {
            throw new AssertionError((Object)("No further requests expected, but got " + request));
        }
        return expectation.handle(request);
    }

    @Override
    public void close() {
        if (!this.expectations.isEmpty()) {
            throw new AssertionError((Object)(this.expectations.size() + " more requests were expected"));
        }
    }

    public void expect(Expectation expectation) {
        this.expectations.add(expectation);
    }

    public void expect(Function<ClassicHttpRequest, String> mapper, int status) {
        this.expect(request -> {
            BasicClassicHttpResponse response = new BasicClassicHttpResponse(status);
            response.setEntity(HttpEntities.create((String)((String)mapper.apply(request)), (ContentType)ContentType.APPLICATION_JSON));
            return response;
        });
    }

    public void expect(BiFunction<HttpURL, String, String> mapper, int status) {
        this.expect(request -> {
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                if (request.getEntity() != null) {
                    request.getEntity().writeTo((OutputStream)buffer);
                }
                BasicClassicHttpResponse response = new BasicClassicHttpResponse(status);
                response.setEntity(HttpEntities.create((String)((String)mapper.apply(HttpURL.from((URI)request.getUri()), buffer.toString(StandardCharsets.UTF_8))), (ContentType)ContentType.APPLICATION_JSON));
                return response;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    @FunctionalInterface
    public static interface Expectation {
        public ClassicHttpResponse handle(ClassicHttpRequest var1) throws IOException;
    }
}

