/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.client;

import ai.vespa.hosted.client.ForwardingInputStream;
import ai.vespa.http.HttpURL;
import com.yahoo.time.TimeBudget;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.Timeout;

public interface HttpClient
extends Closeable {
    public static final RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)5L)).setConnectTimeout(Timeout.ofSeconds((long)5L)).setRedirectsEnabled(false).build();
    public static final ExceptionHandler retryAll = (exception, request) -> {};
    public static final ResponseVerifier throwOnError = new DefaultResponseVerifier(){};

    public static byte[] getBytes(ClassicHttpResponse response) {
        try {
            return response.getEntity() == null ? null : EntityUtils.toByteArray((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public RequestBuilder send(HostStrategy var1, Method var2);

    @FunctionalInterface
    public static interface ExceptionHandler {
        public void handle(IOException var1, ClassicHttpRequest var2);
    }

    @FunctionalInterface
    public static interface ResponseVerifier {
        default public boolean isError(int statusCode) {
            return statusCode < 200 || 300 <= statusCode;
        }

        default public boolean shouldRetry(int statusCode) {
            return statusCode == 503;
        }

        default public void verify(ClassicHttpResponse response, ClassicHttpRequest request) throws IOException {
            if (this.isError(response.getCode())) {
                ClassicHttpResponse classicHttpResponse = response;
                try {
                    byte[] body = response.getEntity() == null ? new byte[]{} : EntityUtils.toByteArray((HttpEntity)response.getEntity());
                    RuntimeException exception = this.toException(response.getCode(), body, request);
                    throw this.shouldRetry(response.getCode()) ? new RetryException(exception) : exception;
                }
                catch (Throwable throwable) {
                    if (classicHttpResponse != null) {
                        try {
                            classicHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }

        public RuntimeException toException(int var1, byte[] var2, ClassicHttpRequest var3);
    }

    public static class ResponseException
    extends RuntimeException {
        public ResponseException(String message) {
            super(message);
        }
    }

    public static final class RetryException
    extends RuntimeException {
        public RetryException(IOException cause) {
            super(Objects.requireNonNull(cause));
        }

        public RetryException(RuntimeException cause) {
            super(Objects.requireNonNull(cause));
        }

        static RetryException wrap(IOException exception, ClassicHttpRequest request) {
            return new RetryException(new UncheckedIOException(request + " failed (" + exception.getClass().getSimpleName() + ")", exception));
        }
    }

    @FunctionalInterface
    public static interface HostStrategy
    extends Iterable<URI> {
        public static HostStrategy ordered(List<URI> hosts) {
            return List.copyOf(hosts)::iterator;
        }

        public static HostStrategy shuffling(List<URI> hosts) {
            return () -> {
                ArrayList copy = new ArrayList(hosts);
                Collections.shuffle(copy);
                return copy.iterator();
            };
        }

        public static HostStrategy repeating(URI host, int count) {
            return HostStrategy.ordered(IntStream.range(0, count).mapToObj(__ -> host).collect(Collectors.toUnmodifiableList()));
        }
    }

    public static interface DefaultResponseVerifier
    extends ResponseVerifier {
        @Override
        default public RuntimeException toException(int statusCode, byte[] body, ClassicHttpRequest request) {
            return new ResponseException(request + " failed with status " + statusCode + " and body '" + new String(body, StandardCharsets.UTF_8) + "'");
        }
    }

    @FunctionalInterface
    public static interface ResponseHandler<T> {
        public T handle(ClassicHttpResponse var1, ClassicHttpRequest var2) throws IOException;
    }

    public static class HttpInputStream
    extends ForwardingInputStream {
        private final ClassicHttpResponse response;

        protected HttpInputStream(ClassicHttpResponse response) throws IOException {
            super(response.getEntity() != null ? response.getEntity().getContent() : InputStream.nullInputStream());
            this.response = response;
        }

        public int statusCode() {
            return this.response.getCode();
        }

        public String contentType() {
            return this.response.getEntity().getContentType();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.response.close();
        }
    }

    public static interface RequestBuilder {
        default public RequestBuilder at(String ... pathSegments) {
            return this.at(List.of(pathSegments));
        }

        default public RequestBuilder at(List<String> pathSegments) {
            return this.at(HttpURL.Path.empty().append(pathSegments).withoutTrailingSlash());
        }

        public RequestBuilder at(HttpURL.Path var1);

        public RequestBuilder body(byte[] var1);

        public RequestBuilder body(HttpEntity var1);

        default public RequestBuilder emptyParameters(String ... keys) {
            return this.emptyParameters(Arrays.asList(keys));
        }

        public RequestBuilder emptyParameters(List<String> var1);

        default public RequestBuilder parameters(String ... pairs) {
            return this.parameters(Arrays.asList(pairs));
        }

        public RequestBuilder parameters(List<String> var1);

        public RequestBuilder parameters(HttpURL.Query var1);

        public RequestBuilder parameters(Supplier<HttpURL.Query> var1);

        public RequestBuilder timeout(Duration var1);

        public RequestBuilder deadline(TimeBudget var1);

        public RequestBuilder addHeader(String var1, String var2);

        public RequestBuilder setHeader(String var1, String var2);

        public RequestBuilder config(RequestConfig var1);

        public RequestBuilder catching(ExceptionHandler var1);

        public RequestBuilder throwing(ResponseVerifier var1);

        public String read();

        public <T> T read(Function<byte[], T> var1);

        public void discard();

        public HttpInputStream stream();

        public <T> T handle(ResponseHandler<T> var1);
    }
}

