/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.hosted.testrunner;

import com.google.inject.Inject;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.hosted.testrunner.PomXmlGenerator;
import com.yahoo.vespa.hosted.testrunner.TestRunnerConfig;
import com.yahoo.vespa.testrunner.legacy.LegacyTestRunner;
import com.yahoo.vespa.testrunner.legacy.TestProfile;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.HtmlAnsiOutputStream;

public class TestRunner
implements LegacyTestRunner {
    private static final Logger logger = Logger.getLogger(TestRunner.class.getName());
    private static final Level HTML = new Level("html", 1){};
    private static final Path vespaHome = Paths.get(Defaults.getDefaults().vespaHome(), new String[0]);
    private static final String settingsXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n          xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n          xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0 http://maven.apache.org/xsd/settings-1.0.0.xsd\">\n    <mirrors>\n        <mirror>\n            <id>maven central</id>\n            <mirrorOf>*</mirrorOf>\n            <url>https://repo.maven.apache.org/maven2/</url>\n        </mirror>\n    </mirrors>\n</settings>";
    private final Path artifactsPath;
    private final Path testPath;
    private final Path logFile;
    private final Path configFile;
    private final Path settingsFile;
    private final Function<TestProfile, ProcessBuilder> testBuilder;
    private final SortedMap<Long, LogRecord> log = new ConcurrentSkipListMap<Long, LogRecord>();
    private volatile LegacyTestRunner.Status status = LegacyTestRunner.Status.NOT_STARTED;

    @Inject
    public TestRunner(TestRunnerConfig config) {
        this(config.artifactsPath(), vespaHome.resolve("tmp/test"), vespaHome.resolve("logs/vespa/maven.log"), vespaHome.resolve("tmp/config.json"), vespaHome.resolve("tmp/settings.xml"), profile -> TestRunner.mavenProcessFrom(profile, config));
    }

    TestRunner(Path artifactsPath, Path testPath, Path logFile, Path configFile, Path settingsFile, Function<TestProfile, ProcessBuilder> testBuilder) {
        this.artifactsPath = artifactsPath;
        this.testPath = testPath;
        this.logFile = logFile;
        this.configFile = configFile;
        this.settingsFile = settingsFile;
        this.testBuilder = testBuilder;
    }

    static ProcessBuilder mavenProcessFrom(TestProfile profile, TestRunnerConfig config) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("mvn");
        command.add("test");
        command.add("--batch-mode");
        command.add("--show-version");
        command.add("--settings");
        command.add(vespaHome.resolve("tmp/settings.xml").toString());
        command.add("-Dorg.slf4j.simpleLogger.log.org.apache.maven.cli.transfer.Slf4jMavenTransferListener=warn");
        command.add("-Dstyle.color=always");
        command.add("-DfailIfNoTests=" + profile.failIfNoTests());
        command.add("-Dvespa.test.config=" + vespaHome.resolve("tmp/config.json"));
        if (config.useAthenzCredentials()) {
            command.add("-Dvespa.test.credentials.root=" + Defaults.getDefaults().vespaHome() + "/var/vespa/sia");
        } else if (config.useTesterCertificate()) {
            command.add("-Dvespa.test.credentials.root=" + config.artifactsPath());
        }
        command.add(String.format("-DargLine=-Xms%1$dm -Xmx%1$dm", config.surefireMemoryMb()));
        command.add("-Dmaven.repo.local=" + vespaHome.resolve("tmp/.m2/repository"));
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.environment().merge("MAVEN_OPTS", " -Djansi.force=true", String::concat);
        builder.directory(vespaHome.resolve("tmp/test").toFile());
        builder.redirectErrorStream(true);
        return builder;
    }

    public synchronized void test(TestProfile testProfile, byte[] testConfig) {
        if (this.status == LegacyTestRunner.Status.RUNNING) {
            throw new IllegalArgumentException("Tests are already running; should not receive this request now.");
        }
        this.log.clear();
        this.status = LegacyTestRunner.Status.RUNNING;
        new Thread(() -> this.runTests(testProfile, testConfig)).start();
    }

    public Collection<LogRecord> getLog(long after) {
        return this.log.tailMap(after + 1L).values();
    }

    public synchronized LegacyTestRunner.Status getStatus() {
        return this.status;
    }

    private void runTests(TestProfile testProfile, byte[] testConfig) {
        boolean success;
        ProcessBuilder builder = this.testBuilder.apply(testProfile);
        LogRecord record = new LogRecord(Level.INFO, String.format("Starting %s. Artifacts directory: %s Config file: %s\nCommand to run: %s\n", testProfile.name(), this.artifactsPath, this.configFile, String.join((CharSequence)" ", builder.command())));
        this.log.put(record.getSequenceNumber(), record);
        logger.log(record);
        this.log.put(record.getSequenceNumber(), record);
        logger.log(record);
        try (PrintStream fileStream = new PrintStream((OutputStream)new AnsiOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.logFile.toFile()))));
             ByteArrayOutputStream logBuffer = new ByteArrayOutputStream();
             PrintStream logFormatter = new PrintStream((OutputStream)new HtmlAnsiOutputStream((OutputStream)logBuffer));){
            this.writeTestApplicationPom(testProfile);
            Files.write(this.configFile, testConfig, new OpenOption[0]);
            Files.write(this.settingsFile, settingsXml.getBytes(), new OpenOption[0]);
            Process mavenProcess = builder.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(mavenProcess.getInputStream()));
            in.lines().forEach(line -> {
                fileStream.println((String)line);
                logFormatter.print((String)line);
                Object message = logBuffer.toString(StandardCharsets.UTF_8);
                if (((String)message).length() > 8192) {
                    message = ((String)message).substring(0, 8192) + " ... (this log entry was truncated due to size)";
                }
                LogRecord record = new LogRecord(HTML, (String)message);
                this.log.put(record.getSequenceNumber(), record);
                logBuffer.reset();
            });
            success = mavenProcess.waitFor() == 0;
        }
        catch (Exception exception) {
            LogRecord record2 = new LogRecord(Level.SEVERE, "Failed to execute maven command: " + String.join((CharSequence)" ", builder.command()));
            record2.setThrown(exception);
            logger.log(record2);
            this.log.put(record2.getSequenceNumber(), record2);
            try (PrintStream file = new PrintStream(new FileOutputStream(this.logFile.toFile(), true));){
                file.println(record2.getMessage());
                exception.printStackTrace(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.status = exception instanceof NoTestsException ? LegacyTestRunner.Status.FAILURE : LegacyTestRunner.Status.ERROR;
            return;
        }
        this.status = success ? LegacyTestRunner.Status.SUCCESS : LegacyTestRunner.Status.FAILURE;
    }

    private void writeTestApplicationPom(TestProfile testProfile) throws IOException {
        List<Path> files = TestRunner.listFiles(this.artifactsPath);
        Path testJar = files.stream().filter(file -> file.toString().endsWith("tests.jar")).findFirst().orElseThrow(() -> new NoTestsException("No file ending with 'tests.jar' found under '" + this.artifactsPath + "'!"));
        String pomXml = PomXmlGenerator.generatePomXml(testProfile, files, testJar);
        this.testPath.toFile().mkdirs();
        Files.write(this.testPath.resolve("pom.xml"), pomXml.getBytes(), new OpenOption[0]);
    }

    private static List<Path> listFiles(Path directory) {
        List<Path> list;
        block8: {
            Stream<Path> element = Files.walk(directory, new FileVisitOption[0]);
            try {
                list = element.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".jar")).collect(Collectors.toList());
                if (element == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (element != null) {
                        try {
                            element.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to list files under " + directory, e);
                }
            }
            element.close();
        }
        return list;
    }

    static class NoTestsException
    extends RuntimeException {
        private NoTestsException(String message) {
            super(message);
        }
    }
}

