/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import ai.vespa.hosted.api.Method;
import ai.vespa.hosted.api.Signatures;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SignatureAlgorithm;
import com.yahoo.security.SignatureUtils;
import com.yahoo.yolean.Exceptions;
import java.net.URI;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestVerifier {
    private static final Logger log = Logger.getLogger(RequestVerifier.class.getName());
    private final Signature verifier;
    private final Clock clock;

    public RequestVerifier(String pemPublicKey) {
        this(pemPublicKey, Clock.systemUTC());
    }

    public RequestVerifier(String pemPublicKey, Clock clock) {
        this(KeyUtils.fromPemEncodedPublicKey((String)pemPublicKey), clock);
    }

    public RequestVerifier(PublicKey publicKey, Clock clock) {
        this.verifier = SignatureUtils.createVerifier((PublicKey)publicKey, (SignatureAlgorithm)SignatureAlgorithm.SHA256_WITH_ECDSA);
        this.clock = clock;
    }

    public boolean verify(Method method, URI requestUri, String timestamp, String contentHash, String signature) {
        try {
            Instant now = this.clock.instant();
            Instant then = Instant.parse(timestamp);
            if (Duration.between(now, then).abs().compareTo(Duration.ofMinutes(5L)) > 0) {
                log.log(Level.INFO, () -> "Rejecting request due to timestamp mismatch of " + String.valueOf(Duration.between(now, then)));
                return false;
            }
            byte[] canonicalMessage = Signatures.canonicalMessageOf(method.name(), requestUri, timestamp, contentHash);
            this.verifier.update(canonicalMessage);
            if (this.verifier.verify(Base64.getDecoder().decode(signature))) {
                return true;
            }
            log.log(Level.INFO, () -> "Rejecting request because of signature mismatch");
            return false;
        }
        catch (RuntimeException | SignatureException e) {
            log.log(Level.INFO, () -> "Exception verifying request: " + Exceptions.toMessageString((Throwable)e));
            return false;
        }
    }
}

