/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import ai.vespa.hosted.api.Method;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiPartStreamer {
    private final String boundary;
    private final List<Supplier<InputStream>> streams;

    MultiPartStreamer(String boundary) {
        this.boundary = boundary;
        this.streams = new ArrayList<Supplier<InputStream>>();
    }

    public MultiPartStreamer() {
        this(UUID.randomUUID().toString());
    }

    public MultiPartStreamer addText(String name, String text) {
        return this.addData(name, "text/plain", text);
    }

    public MultiPartStreamer addJson(String name, String json) {
        return this.addData(name, "application/json", json);
    }

    public MultiPartStreamer addData(String name, String type, String data) {
        this.streams.add(() -> this.separator(name, type));
        this.streams.add(() -> MultiPartStreamer.asStream(data));
        return this;
    }

    public MultiPartStreamer addBytes(String name, byte[] bytes) {
        this.streams.add(() -> this.separator(name, "application/octet-stream"));
        this.streams.add(() -> new ByteArrayInputStream(bytes));
        return this;
    }

    public MultiPartStreamer addFile(String name, Path path) {
        this.streams.add(() -> this.separator(name, path));
        this.streams.add(() -> this.asStream(path));
        return this;
    }

    public HttpRequest.Builder streamTo(HttpRequest.Builder request, Method method) {
        InputStream aggregate = this.data();
        return request.setHeader("Content-Type", this.contentType()).method(method.name(), HttpRequest.BodyPublishers.ofInputStream(() -> aggregate));
    }

    public InputStream data() {
        SequenceInputStream aggregate = new SequenceInputStream(Collections.enumeration(Stream.concat(this.streams.stream().map(Supplier::get), Stream.of(this.end())).collect(Collectors.toList())));
        try {
            if (aggregate.skip(2L) != 2L) {
                throw new IllegalStateException("Failed skipping extraneous bytes.");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed skipping extraneous bytes.", e);
        }
        return new BufferedInputStream(aggregate);
    }

    public String contentType() {
        return "multipart/form-data; boundary=" + this.boundary + "; charset: utf-8";
    }

    private InputStream separator(String name, String contentType) {
        return MultiPartStreamer.asStream(this.disposition(name) + this.type(contentType));
    }

    private InputStream separator(String name, Path path) {
        try {
            String contentType = Files.probeContentType(path);
            return MultiPartStreamer.asStream(this.disposition(name) + "; filename=\"" + path.getFileName() + "\"" + this.type(contentType != null ? contentType : "application/octet-stream"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private InputStream end() {
        return MultiPartStreamer.asStream("\r\n--" + this.boundary + "--");
    }

    private String disposition(String name) {
        return "\r\n--" + this.boundary + "\r\nContent-Disposition: form-data; name=\"" + name + "\"";
    }

    private String type(String contentType) {
        return "\r\nContent-Type: " + contentType + "\r\n\r\n";
    }

    private static InputStream asStream(String string) {
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    private InputStream asStream(Path path) {
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

