/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeStream;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.yolean.Exceptions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TestDescriptor {
    public static final String DEFAULT_FILENAME = "META-INF/ai.vespa/testDescriptor.json";
    public static final String CURRENT_VERSION = "1.0";
    private static final String JSON_FIELD_VERSION = "version";
    private static final String JSON_FIELD_CONFIGURED_TESTS = "configuredTests";
    private static final String JSON_FIELD_SYSTEM_TESTS = "systemTests";
    private static final String JSON_FIELD_STAGING_TESTS = "stagingTests";
    private static final String JSON_FIELD_PRODUCTION_TESTS = "productionTests";
    private final Map<TestCategory, List<String>> configuredTestClasses;
    private final String version;

    private TestDescriptor(String version, Map<TestCategory, List<String>> configuredTestClasses) {
        this.version = version;
        this.configuredTestClasses = configuredTestClasses;
    }

    public static TestDescriptor fromJsonString(String testDescriptor) {
        Slime slime = SlimeUtils.jsonToSlime((String)testDescriptor);
        Cursor root = slime.get();
        String version = root.field(JSON_FIELD_VERSION).asString();
        Cursor testRoot = root.field(JSON_FIELD_CONFIGURED_TESTS);
        List<String> systemTests = TestDescriptor.getJsonArray(testRoot, JSON_FIELD_SYSTEM_TESTS);
        List<String> stagingTests = TestDescriptor.getJsonArray(testRoot, JSON_FIELD_STAGING_TESTS);
        List<String> productionTests = TestDescriptor.getJsonArray(testRoot, JSON_FIELD_PRODUCTION_TESTS);
        return new TestDescriptor(version, TestDescriptor.toMap(systemTests, stagingTests, productionTests));
    }

    public static TestDescriptor from(String version, List<String> systemTests, List<String> stagingTests, List<String> productionTests) {
        return new TestDescriptor(version, TestDescriptor.toMap(systemTests, stagingTests, productionTests));
    }

    private static Map<TestCategory, List<String>> toMap(List<String> systemTests, List<String> stagingTests, List<String> productionTests) {
        return Map.of(TestCategory.systemtest, systemTests, TestCategory.stagingtest, stagingTests, TestCategory.productiontest, productionTests);
    }

    private static List<String> getJsonArray(Cursor cursor, String field) {
        return SlimeStream.fromArray((Inspector)cursor.field(field), Inspector::asString).collect(Collectors.toList());
    }

    public String version() {
        return this.version;
    }

    public List<String> getConfiguredTests(TestCategory category) {
        return List.copyOf((Collection)this.configuredTestClasses.get((Object)category));
    }

    public String toJson() {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString(JSON_FIELD_VERSION, this.version);
        Cursor tests = root.setObject(JSON_FIELD_CONFIGURED_TESTS);
        this.addJsonArrayForTests(tests, JSON_FIELD_SYSTEM_TESTS, TestCategory.systemtest);
        this.addJsonArrayForTests(tests, JSON_FIELD_STAGING_TESTS, TestCategory.stagingtest);
        this.addJsonArrayForTests(tests, JSON_FIELD_PRODUCTION_TESTS, TestCategory.productiontest);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Exceptions.uncheck(() -> new JsonFormat(false).encode((OutputStream)out, slime));
        return out.toString();
    }

    private void addJsonArrayForTests(Cursor testsRoot, String fieldName, TestCategory category) {
        List<String> tests = this.configuredTestClasses.get((Object)category);
        if (tests.isEmpty()) {
            return;
        }
        Cursor cursor = testsRoot.setArray(fieldName);
        tests.forEach(arg_0 -> ((Cursor)cursor).addString(arg_0));
    }

    public String toString() {
        return "TestClassDescriptor{configuredTestClasses=" + this.configuredTestClasses + "}";
    }

    public static enum TestCategory {
        systemtest,
        stagingtest,
        productiontest;

    }
}

