/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeStream;
import com.yahoo.slime.SlimeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TestDescriptor {
    public static final String DEFAULT_FILENAME = "META-INF/ai.vespa/testDescriptor.json";
    private final Map<TestCategory, List<String>> configuredTestClasses;
    private final String version;

    private TestDescriptor(String version, Map<TestCategory, List<String>> configuredTestClasses) {
        this.version = version;
        this.configuredTestClasses = configuredTestClasses;
    }

    public static TestDescriptor fromJsonString(String testDescriptor) {
        Slime slime = SlimeUtils.jsonToSlime((String)testDescriptor);
        Cursor root = slime.get();
        String version = root.field("version").asString();
        Cursor testRoot = root.field("configuredTests");
        List<String> systemTests = TestDescriptor.getJsonArray(testRoot, "systemTests");
        List<String> stagingTests = TestDescriptor.getJsonArray(testRoot, "stagingTests");
        List<String> productionTests = TestDescriptor.getJsonArray(testRoot, "productionTests");
        return new TestDescriptor(version, Map.of(TestCategory.systemtest, systemTests, TestCategory.stagingtest, stagingTests, TestCategory.productiontest, productionTests));
    }

    private static List<String> getJsonArray(Cursor cursor, String field) {
        return SlimeStream.fromArray((Inspector)cursor.field(field), Inspector::asString).collect(Collectors.toList());
    }

    public String version() {
        return this.version;
    }

    public List<String> getConfiguredTests(TestCategory category) {
        return List.copyOf((Collection)this.configuredTestClasses.get((Object)category));
    }

    public String toString() {
        return "TestClassDescriptor{configuredTestClasses=" + this.configuredTestClasses + "}";
    }

    public static enum TestCategory {
        systemtest,
        stagingtest,
        productiontest;

    }
}

