/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import ai.vespa.hosted.api.Deployment;
import ai.vespa.hosted.api.DeploymentLog;
import ai.vespa.hosted.api.DeploymentResult;
import ai.vespa.hosted.api.Method;
import ai.vespa.hosted.api.MultiPartStreamer;
import ai.vespa.hosted.api.RequestSigner;
import ai.vespa.hosted.api.Submission;
import ai.vespa.hosted.api.TestConfig;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.zone.ZoneId;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;

public abstract class ControllerHttpClient {
    private final HttpClient client;
    private final URI endpoint;

    protected ControllerHttpClient(URI endpoint, HttpClient.Builder client) {
        this.endpoint = endpoint.resolve("/");
        this.client = client.connectTimeout(Duration.ofSeconds(5L)).version(HttpClient.Version.HTTP_1_1).build();
    }

    public static ControllerHttpClient withSignatureKey(URI endpoint, String privateKey, ApplicationId id) {
        return new SigningControllerHttpClient(endpoint, privateKey, id);
    }

    public static ControllerHttpClient withSignatureKey(URI endpoint, Path privateKeyFile, ApplicationId id) {
        return new SigningControllerHttpClient(endpoint, privateKeyFile, id);
    }

    public static ControllerHttpClient withSSLContext(URI endpoint, SSLContext sslContext) {
        return new MutualTlsControllerHttpClient(endpoint, sslContext);
    }

    public static ControllerHttpClient withKeyAndCertificate(URI endpoint, Path privateKeyFile, Path certificateFile) {
        PrivateKey privateKey = ControllerHttpClient.unchecked(() -> KeyUtils.fromPemEncodedPrivateKey((String)Files.readString(privateKeyFile, StandardCharsets.UTF_8)));
        List certificates = ControllerHttpClient.unchecked(() -> X509CertificateUtils.certificateListFromPem((String)Files.readString(certificateFile, StandardCharsets.UTF_8)));
        for (X509Certificate certificate : certificates) {
            if (!Instant.now().isBefore(certificate.getNotBefore().toInstant()) && !Instant.now().isAfter(certificate.getNotAfter().toInstant())) continue;
            throw new IllegalStateException("Certificate at '" + certificateFile + "' is valid between " + certificate.getNotBefore() + " and " + certificate.getNotAfter() + " \u2014 not now.");
        }
        return new MutualTlsControllerHttpClient(endpoint, privateKey, certificates);
    }

    public String submit(Submission submission, TenantName tenant, ApplicationName application) {
        return ControllerHttpClient.toMessage(this.send(this.request(HttpRequest.newBuilder(this.applicationPath(tenant, application).resolve("submit")).timeout(Duration.ofMinutes(30L)), Method.POST, new MultiPartStreamer().addJson("submitOptions", ControllerHttpClient.metaToJson(submission)).addFile("applicationZip", submission.applicationZip()).addFile("applicationTestZip", submission.applicationTestZip()))));
    }

    public DeploymentResult deploy(Deployment deployment, ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.toDeploymentResult(this.send(this.request(HttpRequest.newBuilder(this.deploymentJobPath(id, zone)).timeout(Duration.ofMinutes(20L)), Method.POST, ControllerHttpClient.toDataStream(deployment))));
    }

    public String deactivate(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.toMessage(this.send(this.request(HttpRequest.newBuilder(this.deploymentPath(id, zone)).timeout(Duration.ofMinutes(3L)), Method.DELETE)));
    }

    public ZoneId defaultZone(Environment environment) {
        Inspector rootObject = ControllerHttpClient.toInspector(this.send(this.request(HttpRequest.newBuilder(this.defaultRegionPath(environment)).timeout(Duration.ofSeconds(10L)), Method.GET)));
        return ZoneId.from((String)environment.value(), (String)rootObject.field("name").asString());
    }

    public String compileVersion(ApplicationId id) {
        return ControllerHttpClient.toInspector(this.send(this.request(HttpRequest.newBuilder(this.applicationPath(id.tenant(), id.application())).timeout(Duration.ofSeconds(20L)), Method.GET))).field("compileVersion").asString();
    }

    public TestConfig testConfig(ApplicationId id, ZoneId zone) {
        return TestConfig.fromJson(this.send(this.request(HttpRequest.newBuilder(this.testConfigPath(id, zone)).timeout(Duration.ofSeconds(10L)), Method.GET)).body());
    }

    public DeploymentLog deploymentLog(ApplicationId id, ZoneId zone, long run, long after) {
        return ControllerHttpClient.toDeploymentLog(this.send(this.request(HttpRequest.newBuilder(this.runPath(id, zone, run, after)).timeout(Duration.ofSeconds(10L)), Method.GET)));
    }

    public DeploymentLog followDeploymentUntilDone(ApplicationId id, ZoneId zone, long run, Consumer<DeploymentLog.Entry> out) {
        long last = -1L;
        DeploymentLog log = null;
        while (true) {
            DeploymentLog update = this.deploymentLog(id, zone, run, last);
            for (DeploymentLog.Entry entry : update.entries()) {
                out.accept(entry);
            }
            log = log == null ? update : log.updatedWith(update);
            last = log.last().orElse(last);
            if (!log.isActive()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return log;
    }

    public DeploymentLog deploymentLog(ApplicationId id, ZoneId zone, long run) {
        return this.deploymentLog(id, zone, run, -1L);
    }

    protected HttpRequest request(HttpRequest.Builder request, Method method, Supplier<InputStream> data) {
        return request.method(method.name(), HttpRequest.BodyPublishers.ofInputStream(data)).build();
    }

    private HttpRequest request(HttpRequest.Builder request, Method method) {
        return this.request(request, method, InputStream::nullInputStream);
    }

    private HttpRequest request(HttpRequest.Builder request, Method method, byte[] data) {
        return this.request(request, method, () -> new ByteArrayInputStream(data));
    }

    private HttpRequest request(HttpRequest.Builder request, Method method, MultiPartStreamer data) {
        return this.request(request.setHeader("Content-Type", data.contentType()), method, data::data);
    }

    private URI applicationApiPath() {
        return ControllerHttpClient.concatenated(this.endpoint, "application", "v4");
    }

    private URI tenantPath(TenantName tenant) {
        return ControllerHttpClient.concatenated(this.applicationApiPath(), "tenant", tenant.value());
    }

    private URI applicationPath(TenantName tenant, ApplicationName application) {
        return ControllerHttpClient.concatenated(this.tenantPath(tenant), "application", application.value());
    }

    private URI instancePath(ApplicationId id) {
        return ControllerHttpClient.concatenated(this.applicationPath(id.tenant(), id.application()), "instance", id.instance().value());
    }

    private URI deploymentPath(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.concatenated(this.instancePath(id), "environment", zone.environment().value(), "region", zone.region().value());
    }

    private URI deploymentJobPath(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.concatenated(this.instancePath(id), "deploy", ControllerHttpClient.jobNameOf(zone));
    }

    private URI jobPath(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.concatenated(this.instancePath(id), "job", ControllerHttpClient.jobNameOf(zone));
    }

    private URI testConfigPath(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.concatenated(this.jobPath(id, zone), "test-config");
    }

    private URI runPath(ApplicationId id, ZoneId zone, long run, long after) {
        return ControllerHttpClient.withQuery(ControllerHttpClient.concatenated(this.jobPath(id, zone), "run", Long.toString(run)), "after", Long.toString(after));
    }

    private URI defaultRegionPath(Environment environment) {
        return ControllerHttpClient.concatenated(this.endpoint, "zone", "v1", "environment", environment.value(), "default");
    }

    private static URI concatenated(URI base, String ... parts) {
        return base.resolve(Stream.of(parts).map(part -> URLEncoder.encode(part, StandardCharsets.UTF_8)).collect(Collectors.joining("/")) + "/");
    }

    private static URI withQuery(URI base, String name, String value) {
        return base.resolve("?" + (String)(base.getRawQuery() != null ? base.getRawQuery() + "&" : "") + URLEncoder.encode(name, StandardCharsets.UTF_8) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8));
    }

    private static String jobNameOf(ZoneId zone) {
        return (zone.environment().isProduction() ? "production" : zone.environment().value()) + "-" + zone.region().value();
    }

    private HttpResponse<byte[]> send(HttpRequest request) {
        Throwable thrown = null;
        for (int attempt = 1; attempt <= 10; ++attempt) {
            try {
                HttpResponse<byte[]> response = this.client.send(request, HttpResponse.BodyHandlers.ofByteArray());
                if (response.statusCode() / 100 == 2) {
                    return response;
                }
                Cursor rootObject = ControllerHttpClient.toSlime(response.body()).get();
                String message = response.request() + " returned code " + response.statusCode() + (String)(rootObject.field("error-code").valid() ? " (" + rootObject.field("error-code").asString() + ")" : "") + ": " + rootObject.field("message").asString();
                if (response.statusCode() / 100 == 4) {
                    throw new IllegalArgumentException(message);
                }
                throw new IOException(message);
            }
            catch (IOException e) {
                if (thrown == null) {
                    thrown = new UncheckedIOException(e);
                } else {
                    thrown.addSuppressed(e);
                }
                if (attempt >= 10) continue;
                try {
                    Thread.sleep(100 << attempt);
                    continue;
                }
                catch (InterruptedException f) {
                    throw new RuntimeException(f);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw thrown;
    }

    private static <T> T unchecked(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String metaToJson(Deployment deployment) {
        Slime slime = new Slime();
        Cursor rootObject = slime.setObject();
        deployment.version().ifPresent(version -> rootObject.setString("vespaVersion", version));
        rootObject.setBool("deployDirectly", true);
        return ControllerHttpClient.toJson(slime);
    }

    private static String metaToJson(Submission submission) {
        Slime slime = new Slime();
        Cursor rootObject = slime.setObject();
        submission.repository().ifPresent(repository -> rootObject.setString("repository", repository));
        submission.branch().ifPresent(branch -> rootObject.setString("branch", branch));
        submission.commit().ifPresent(commit -> rootObject.setString("commit", commit));
        submission.sourceUrl().ifPresent(url -> rootObject.setString("sourceUrl", url));
        submission.authorEmail().ifPresent(email -> rootObject.setString("authorEmail", email));
        submission.projectId().ifPresent(projectId -> rootObject.setLong("projectId", projectId.longValue()));
        return ControllerHttpClient.toJson(slime);
    }

    private static MultiPartStreamer toDataStream(Deployment deployment) {
        MultiPartStreamer streamer = new MultiPartStreamer();
        streamer.addJson("deployOptions", ControllerHttpClient.metaToJson(deployment));
        streamer.addFile("applicationZip", deployment.applicationZip());
        return streamer;
    }

    private static String asString(HttpResponse<byte[]> response) {
        return new String(response.body(), StandardCharsets.UTF_8);
    }

    private static Inspector toInspector(HttpResponse<byte[]> response) {
        return ControllerHttpClient.toSlime(response.body()).get();
    }

    private static String toMessage(HttpResponse<byte[]> response) {
        return ControllerHttpClient.toInspector(response).field("message").asString();
    }

    private static DeploymentResult toDeploymentResult(HttpResponse<byte[]> response) {
        Inspector rootObject = ControllerHttpClient.toInspector(response);
        return new DeploymentResult(rootObject.field("message").asString(), rootObject.field("run").asLong());
    }

    private static DeploymentLog toDeploymentLog(HttpResponse<byte[]> response) {
        Inspector rootObject = ControllerHttpClient.toInspector(response);
        ArrayList<DeploymentLog.Entry> entries = new ArrayList<DeploymentLog.Entry>();
        rootObject.field("log").traverse((step, entryArray) -> entryArray.traverse((___, entryObject) -> entries.add(new DeploymentLog.Entry(Instant.ofEpochMilli(entryObject.field("at").asLong()), DeploymentLog.Level.of(entryObject.field("type").asString()), entryObject.field("message").asString(), "copyVespaLogs".equals(step)))));
        return new DeploymentLog(entries, rootObject.field("active").asBool(), ControllerHttpClient.valueOf(rootObject.field("status").asString()), rootObject.field("lastId").valid() ? OptionalLong.of(rootObject.field("lastId").asLong()) : OptionalLong.empty());
    }

    private static Slime toSlime(byte[] data) {
        return new JsonDecoder().decode(new Slime(), data);
    }

    private static String toJson(Slime slime) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            new JsonFormat(true).encode((OutputStream)buffer, slime);
            return buffer.toString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static DeploymentLog.Status valueOf(String status) {
        switch (status) {
            case "running": {
                return DeploymentLog.Status.running;
            }
            case "aborted": {
                return DeploymentLog.Status.aborted;
            }
            case "error": {
                return DeploymentLog.Status.error;
            }
            case "testFailure": {
                return DeploymentLog.Status.testFailure;
            }
            case "outOfCapacity": {
                return DeploymentLog.Status.outOfCapacity;
            }
            case "installationFailed": {
                return DeploymentLog.Status.installationFailed;
            }
            case "deploymentFailed": {
                return DeploymentLog.Status.deploymentFailed;
            }
            case "success": {
                return DeploymentLog.Status.success;
            }
        }
        throw new IllegalArgumentException("Unexpected status '" + status + "'");
    }

    private static class MutualTlsControllerHttpClient
    extends ControllerHttpClient {
        private MutualTlsControllerHttpClient(URI endpoint, SSLContext sslContext) {
            super(endpoint, HttpClient.newBuilder().sslContext(sslContext));
        }

        private MutualTlsControllerHttpClient(URI endpoint, PrivateKey privateKey, List<X509Certificate> certs) {
            this(endpoint, new SslContextBuilder().withKeyStore(privateKey, certs).build());
        }
    }

    private static class SigningControllerHttpClient
    extends ControllerHttpClient {
        private final RequestSigner signer;

        private SigningControllerHttpClient(URI endpoint, String privateKey, ApplicationId id) {
            super(endpoint, HttpClient.newBuilder());
            this.signer = new RequestSigner(privateKey, id.serializedForm());
        }

        private SigningControllerHttpClient(URI endpoint, Path privateKeyFile, ApplicationId id) {
            this(endpoint, ControllerHttpClient.unchecked(() -> Files.readString(privateKeyFile, StandardCharsets.UTF_8)), id);
        }

        @Override
        protected HttpRequest request(HttpRequest.Builder request, Method method, Supplier<InputStream> data) {
            return this.signer.signed(request, method, data);
        }
    }
}

