/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fsa;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class MetaData {
    private final boolean _ok;
    private final MappedByteBuffer _header;
    private final MappedByteBuffer _data;
    private final Charset _charset;

    public MetaData(String filename) {
        this(filename, "utf-8");
    }

    public MetaData(String filename, String charsetname) {
        boolean ok = false;
        MappedByteBuffer header = null;
        MappedByteBuffer data = null;
        this._charset = Charset.forName(charsetname);
        try (FileInputStream file = new FileInputStream(filename);){
            header = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 256L);
            header.order(ByteOrder.LITTLE_ENDIAN);
            if (this.h_magic() != -2025936501) {
                System.out.print("MetaData bad magic " + this.h_magic() + "\n");
            } else {
                data = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 256L, this.h_size());
                data.order(ByteOrder.LITTLE_ENDIAN);
                ok = true;
            }
        }
        catch (FileNotFoundException e) {
            System.out.print("MetaData file " + filename + " not found.\n");
        }
        catch (IOException e) {
            System.out.print("MetaData IO exception.\n");
        }
        this._ok = ok;
        this._header = header;
        this._data = data;
    }

    public boolean isOk() {
        return this._ok;
    }

    private int h_magic() {
        return this._header.getInt(0);
    }

    private int h_version() {
        return this._header.getInt(4);
    }

    private int h_checksum() {
        return this._header.getInt(8);
    }

    private int h_size() {
        return this._header.getInt(12);
    }

    private int h_reserved(int i) {
        if (i < 0 || i > 9) {
            return 0;
        }
        return this._header.getInt(16 + 4 * i);
    }

    private int h_user(int i) {
        if (i < 0 || i > 49) {
            return 0;
        }
        return this._header.getInt(56 + 4 * i);
    }

    private ByteBuffer encode(CharBuffer chrbuf) {
        return this._charset.encode(chrbuf);
    }

    private String decode(ByteBuffer buf) {
        return this._charset.decode(buf).toString();
    }

    public int user(int i) {
        if (!this._ok) {
            return 0;
        }
        return this.h_user(i);
    }

    public int getIntEntry(int idx) {
        if (this._ok) {
            return this._data.getInt(idx * 4);
        }
        return 0;
    }

    public ByteBuffer getDirectRecordEntry(int idx, int size) {
        if (this._ok) {
            ByteBuffer meta = ByteBuffer.allocate(size);
            meta.order(ByteOrder.LITTLE_ENDIAN);
            this._data.position(idx * size);
            this._data.get(meta.array(), 0, size);
            return meta;
        }
        return null;
    }

    public ByteBuffer getIndirectRecordEntry(int idx, int size) {
        if (this._ok) {
            int offset = this._data.getInt(idx * 4);
            ByteBuffer meta = ByteBuffer.allocate(size);
            meta.order(ByteOrder.LITTLE_ENDIAN);
            this._data.position(offset);
            this._data.get(meta.array(), 0, size);
            return meta;
        }
        return null;
    }

    public ByteBuffer getIndirectRecordEntry(int idx) {
        if (this._ok) {
            int offset = this._data.getInt(idx * 4);
            int size = this._data.getInt(offset);
            ByteBuffer meta = ByteBuffer.allocate(size);
            meta.order(ByteOrder.LITTLE_ENDIAN);
            this._data.position(offset + 4);
            this._data.get(meta.array(), 0, size);
            return meta;
        }
        return null;
    }

    public String getStringEntry(int stringOffset) {
        if (this._ok) {
            int length = 0;
            this._data.position(stringOffset);
            while (this._data.get() != 0) {
                ++length;
            }
            ByteBuffer meta = ByteBuffer.allocate(length);
            meta.order(ByteOrder.LITTLE_ENDIAN);
            this._data.position(stringOffset);
            this._data.get(meta.array(), 0, length);
            return this.decode(meta);
        }
        return null;
    }

    public String[] getStringArrayEntry(int stringOffset, int numStrings) {
        if (this._ok && numStrings > 0) {
            String[] stringArray = new String[numStrings];
            int pos = stringOffset;
            for (int i = 0; i < numStrings; ++i) {
                int length = 0;
                this._data.position(pos);
                while (this._data.get() != 0) {
                    ++length;
                }
                ByteBuffer meta = ByteBuffer.allocate(length);
                meta.order(ByteOrder.LITTLE_ENDIAN);
                this._data.position(pos);
                this._data.get(meta.array(), 0, length);
                stringArray[i] = this.decode(meta);
                pos += length + 1;
            }
            return stringArray;
        }
        return null;
    }

    public static void main(String[] args) {
        String file = "dmozPred_2.dat";
        MetaData metaData = new MetaData(file);
        System.out.println("Loading MetaData " + file + ": " + metaData.isOk());
    }
}

