/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fsa.segmenter;

import com.yahoo.fsa.FSA;
import com.yahoo.fsa.segmenter.Segment;
import com.yahoo.fsa.segmenter.Segments;
import java.util.LinkedList;
import java.util.ListIterator;

public class Segmenter {
    private final FSA fsa;

    public Segmenter(FSA fsa) {
        this.fsa = fsa;
    }

    public Segmenter(String filename) {
        this.fsa = new FSA(filename, "utf-8");
    }

    public Segmenter(String filename, String charsetname) {
        this.fsa = new FSA(filename, charsetname);
    }

    public boolean isOk() {
        return this.fsa.isOk();
    }

    public Segments segment(String input) {
        String[] tokens = input.split("\\s");
        return this.segment(tokens);
    }

    public Segments segment(String[] tokens) {
        Segments segments = new Segments(tokens);
        LinkedList<Detector> detectors = new LinkedList<Detector>();
        for (int i = 0; i < tokens.length; ++i) {
            detectors.add(new Detector(this.fsa.getState(), i));
            ListIterator det_it = detectors.listIterator();
            while (det_it.hasNext()) {
                Detector d = (Detector)det_it.next();
                d.state().deltaWord(tokens[i]);
                if (d.state().isFinal()) {
                    segments.add(new Segment(d.index(), i + 1, d.state().data().getInt(0)));
                }
                if (d.state().isValid()) continue;
                det_it.remove();
            }
        }
        return segments;
    }

    private class Detector {
        final FSA.State state;
        final int index;

        public Detector(FSA.State s, int i) {
            this.state = s;
            this.index = i;
        }

        public FSA.State state() {
            return this.state;
        }

        public int index() {
            return this.index;
        }
    }
}

