/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fsa.conceptnet;

import com.yahoo.fsa.FSA;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class ConceptNet {
    private FSA _fsa;
    private boolean _ok = false;
    private MappedByteBuffer _header;
    private MappedByteBuffer _index;
    private MappedByteBuffer _info;
    private MappedByteBuffer _catindex;
    private MappedByteBuffer _strings;
    private Charset _charset;

    public ConceptNet(String domain) {
        this.init(domain, "utf-8");
    }

    public ConceptNet(String domain, String charsetname) {
        this.init(domain, charsetname);
    }

    public boolean isOk() {
        return this._ok;
    }

    private void init(String domain, String charsetname) {
        FileInputStream file;
        this._charset = Charset.forName(charsetname);
        this._fsa = new FSA(domain + ".fsa", charsetname);
        if (!this._fsa.isOk()) {
            return;
        }
        try {
            file = new FileInputStream(domain + ".dat");
        }
        catch (FileNotFoundException e) {
            System.out.print("ConceptNet data file " + domain + ".dat not found.\n");
            return;
        }
        try {
            this._header = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 256L);
            this._header.order(ByteOrder.LITTLE_ENDIAN);
            if (this.h_magic() != 238579428) {
                System.out.print("ConceptNet bad magic " + this.h_magic() + "\n");
                return;
            }
            this._index = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 256L, 32 * this.h_index_size());
            this._index.order(ByteOrder.LITTLE_ENDIAN);
            this._info = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 256 + 32 * this.h_index_size(), 4 * this.h_info_size());
            this._info.order(ByteOrder.LITTLE_ENDIAN);
            this._catindex = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 256 + 32 * this.h_index_size() + 4 * this.h_info_size(), 4 * this.h_catindex_size());
            this._catindex.order(ByteOrder.LITTLE_ENDIAN);
            this._strings = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 256 + 32 * this.h_index_size() + 4 * this.h_info_size() + 4 * this.h_catindex_size(), this.h_strings_size());
            this._strings.order(ByteOrder.LITTLE_ENDIAN);
            this._ok = true;
        }
        catch (IOException e) {
            System.out.print("ConceptNet IO exception.\n");
            return;
        }
    }

    private int h_magic() {
        return this._header.getInt(0);
    }

    private int h_version() {
        return this._header.getInt(4);
    }

    private int h_checksum() {
        return this._header.getInt(8);
    }

    private int h_index_size() {
        return this._header.getInt(12);
    }

    private int h_info_size() {
        return this._header.getInt(16);
    }

    private int h_catindex_size() {
        return this._header.getInt(20);
    }

    private int h_strings_size() {
        return this._header.getInt(24);
    }

    private int h_max_freq() {
        return this._header.getInt(28);
    }

    private int h_max_cfreq() {
        return this._header.getInt(32);
    }

    private int h_max_qfreq() {
        return this._header.getInt(36);
    }

    private int h_max_sfreq() {
        return this._header.getInt(40);
    }

    private int h_max_efreq() {
        return this._header.getInt(44);
    }

    private int h_max_afreq() {
        return this._header.getInt(48);
    }

    private ByteBuffer encode(CharBuffer chrbuf) {
        return this._charset.encode(chrbuf);
    }

    private String decode(ByteBuffer buf) {
        return this._charset.decode(buf).toString();
    }

    public int lookup(String unit) {
        FSA.State state = this._fsa.getState();
        state.delta(unit);
        if (state.isFinal()) {
            return state.hash();
        }
        return -1;
    }

    public String lookup(int idx) {
        if (!this._ok || idx < 0 || idx >= this.h_index_size()) {
            return null;
        }
        int termoffset = this._index.getInt(32 * idx);
        return this.getString(termoffset);
    }

    private String getString(int stringOffset) {
        if (this._ok) {
            int length = 0;
            this._strings.position(stringOffset);
            while (this._strings.get() != 0) {
                ++length;
            }
            ByteBuffer meta = ByteBuffer.allocate(length);
            this._strings.position(stringOffset);
            this._strings.get(meta.array(), 0, length);
            return this.decode(meta);
        }
        return null;
    }

    public int frq(int idx) {
        if (!this._ok || idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        return this._index.getInt(32 * idx + 4);
    }

    public int cFrq(int idx) {
        if (!this._ok || idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        return this._index.getInt(32 * idx + 8);
    }

    public int qFrq(int idx) {
        if (!this._ok || idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        return this._index.getInt(32 * idx + 12);
    }

    public int sFrq(int idx) {
        if (!this._ok || idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        return this._index.getInt(32 * idx + 16);
    }

    public double score(int idx) {
        if (!this._ok || idx < 0 || idx >= this.h_index_size()) {
            return -1.0;
        }
        return 100.0 * (double)this.cFrq(idx) / (double)this.qFrq(idx);
    }

    public double strength(int idx) {
        if (!this._ok || idx < 0 || idx >= this.h_index_size()) {
            return -1.0;
        }
        return 100.0 * (double)this.qFrq(idx) / (double)this.sFrq(idx);
    }

    public int numExt(int idx) {
        if (idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        int offset = this._index.getInt(32 * idx + 20);
        if (offset == 0) {
            return 0;
        }
        return this._info.getInt(4 * offset);
    }

    public int ext(int idx, int i) {
        if (idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        int offset = this._index.getInt(32 * idx + 20);
        if (offset == 0) {
            return -1;
        }
        if (i >= this._info.getInt(4 * offset)) {
            return -1;
        }
        return this._info.getInt(4 * offset + 4 + 8 * i);
    }

    public int extFrq(int idx, int i) {
        if (idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        int offset = this._index.getInt(32 * idx + 20);
        if (offset == 0) {
            return -1;
        }
        if (i >= this._info.getInt(4 * offset)) {
            return -1;
        }
        return this._info.getInt(4 * offset + 8 + 8 * i);
    }

    public int numAssoc(int idx) {
        if (idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        int offset = this._index.getInt(32 * idx + 24);
        if (offset == 0) {
            return 0;
        }
        return this._info.getInt(4 * offset);
    }

    public int assoc(int idx, int i) {
        if (idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        int offset = this._index.getInt(32 * idx + 24);
        if (offset == 0) {
            return -1;
        }
        if (i >= this._info.getInt(4 * offset)) {
            return -1;
        }
        return this._info.getInt(4 * offset + 4 + 8 * i);
    }

    public int assocFrq(int idx, int i) {
        if (idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        int offset = this._index.getInt(32 * idx + 24);
        if (offset == 0) {
            return -1;
        }
        if (i >= this._info.getInt(4 * offset)) {
            return -1;
        }
        return this._info.getInt(4 * offset + 8 + 8 * i);
    }

    public int numCat(int idx) {
        if (idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        int offset = this._index.getInt(32 * idx + 28);
        if (offset == 0) {
            return 0;
        }
        return this._info.getInt(4 * offset);
    }

    public int cat(int idx, int i) {
        if (idx < 0 || idx >= this.h_index_size()) {
            return -1;
        }
        int offset = this._index.getInt(32 * idx + 28);
        if (offset == 0) {
            return -1;
        }
        if (i >= this._info.getInt(4 * offset)) {
            return -1;
        }
        return this._info.getInt(4 * offset + 4 + 8 * i);
    }

    public String catName(int catidx) {
        if (!this._ok || catidx < 0 || catidx >= this.h_catindex_size()) {
            return null;
        }
        int catoffset = this._catindex.getInt(4 * catidx);
        return this.getString(catoffset);
    }

    public static void main(String[] args) {
        int i;
        String domain = "/home/gv/fsa/automata/us_main_20041002_20041008";
        ConceptNet cn = new ConceptNet(domain);
        System.out.println("Loading ConceptNet domain " + domain + ": " + cn.isOk());
        int idx = cn.lookup("new york");
        System.out.println("  lookup(\"new york\") -> " + idx);
        System.out.println("  lookup(" + idx + ")     -> " + cn.lookup(idx) + "(" + cn.score(idx) + "," + cn.strength(idx) + ")");
        System.out.println("    extensions(" + cn.numExt(idx) + "):");
        for (i = 0; i < 5 && i < cn.numExt(idx); ++i) {
            System.out.println("      " + cn.lookup(cn.ext(idx, i)) + "," + cn.extFrq(idx, i));
        }
        if (5 < cn.numExt(idx)) {
            System.out.println("      ...");
        }
        System.out.println("    associations(" + cn.numAssoc(idx) + "):");
        for (i = 0; i < 5 && i < cn.numAssoc(idx); ++i) {
            System.out.println("      " + cn.lookup(cn.assoc(idx, i)) + "," + cn.assocFrq(idx, i));
        }
        if (5 < cn.numAssoc(idx)) {
            System.out.println("      ...");
        }
        System.out.println("    categories(" + cn.numCat(idx) + "):");
        for (i = 0; i < 5 && i < cn.numCat(idx); ++i) {
            System.out.println("      " + cn.catName(cn.cat(idx, i)));
        }
        if (5 < cn.numCat(idx)) {
            System.out.println("      ...");
        }
    }
}

