/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fsa.segmenter;

import com.yahoo.fsa.FSA;
import com.yahoo.fsa.segmenter.Segment;
import com.yahoo.fsa.segmenter.Segments;
import java.util.LinkedList;
import java.util.ListIterator;

public class Segmenter {
    private FSA _fsa;

    public Segmenter(FSA fsa) {
        this._fsa = fsa;
    }

    public Segmenter(String filename) {
        this._fsa = new FSA(filename, "utf-8");
    }

    public Segmenter(String filename, String charsetname) {
        this._fsa = new FSA(filename, charsetname);
    }

    public boolean isOk() {
        return this._fsa.isOk();
    }

    public Segments segment(String input) {
        String[] tokens = input.split("\\s");
        return this.segment(tokens);
    }

    public Segments segment(String[] tokens) {
        Segments segments = new Segments(tokens);
        LinkedList<Detector> detectors = new LinkedList<Detector>();
        for (int i = 0; i < tokens.length; ++i) {
            detectors.add(new Detector(this._fsa.getState(), i));
            ListIterator det_it = detectors.listIterator();
            while (det_it.hasNext()) {
                Detector d = (Detector)det_it.next();
                d.state().deltaWord(tokens[i]);
                if (d.state().isFinal()) {
                    segments.add(new Segment(d.index(), i + 1, d.state().data().getInt(0)));
                }
                if (d.state().isValid()) continue;
                det_it.remove();
            }
        }
        return segments;
    }

    public static void main(String[] args) {
        String fsafile = "/home/gv/fsa/automata/segments.fsa";
        Segmenter segmenter = new Segmenter(fsafile);
        System.out.println("Loading segmenter FSA file " + fsafile + ": " + segmenter.isOk());
        for (int a = 0; a < 1 || a < args.length; ++a) {
            int i;
            String query = a == args.length ? "times square head" : args[a];
            System.out.println("processing query \"" + query + "\"");
            Segments segments = segmenter.segment(query);
            System.out.println("all segments:");
            for (int i2 = 0; i2 < segments.size(); ++i2) {
                System.out.println("  " + i2 + ": \"" + segments.sgm(i2) + "\"," + segments.conn(i2));
            }
            Segments best = segments.segmentation(0);
            System.out.print("best segments (weighted): ");
            for (i = 0; i < best.size(); ++i) {
                System.out.print("(" + best.sgm(i) + ")");
            }
            System.out.println();
            best = segments.segmentation(10);
            System.out.print("best segments (rightmost_longest):");
            for (i = 0; i < best.size(); ++i) {
                System.out.print("(" + best.sgm(i) + ")");
            }
            System.out.println();
        }
    }

    private class Detector {
        FSA.State _state;
        int _index;

        public Detector(FSA.State s, int i) {
            this._state = s;
            this._index = i;
        }

        public FSA.State state() {
            return this._state;
        }

        public int index() {
            return this._index;
        }
    }
}

