/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fsa.segmenter;

import com.yahoo.fsa.segmenter.Segment;
import java.util.LinkedList;

public class Segments
extends LinkedList {
    public static final int SEGMENTATION_WEIGHTED = 0;
    public static final int SEGMENTATION_WEIGHTED_BIAS10 = 1;
    public static final int SEGMENTATION_WEIGHTED_BIAS20 = 2;
    public static final int SEGMENTATION_WEIGHTED_BIAS50 = 3;
    public static final int SEGMENTATION_WEIGHTED_BIAS100 = 4;
    public static final int SEGMENTATION_WEIGHTED_LEFTMOST = 5;
    public static final int SEGMENTATION_WEIGHTED_RIGHTMOST = 6;
    public static final int SEGMENTATION_WEIGHTED_LONGEST = 7;
    public static final int SEGMENTATION_LEFTMOST_LONGEST = 8;
    public static final int SEGMENTATION_LEFTMOST_WEIGHTED = 9;
    public static final int SEGMENTATION_RIGHTMOST_LONGEST = 10;
    public static final int SEGMENTATION_RIGHTMOST_WEIGHTED = 11;
    public static final int SEGMENTATION_LONGEST_WEIGHTED = 12;
    public static final int SEGMENTATION_LONGEST_LEFTMOST = 13;
    public static final int SEGMENTATION_LONGEST_RIGHTMOST = 14;
    public static final int SEGMENTATION_METHODS = 15;
    private String[] _tokens;
    private int _size;
    private int[][] _map;

    public Segments(String[] tokens) {
        this._tokens = tokens;
        this._size = tokens.length;
        this._map = new int[this._size + 1][this._size + 1];
        for (int i = 0; i <= this._size; ++i) {
            for (int j = 0; j <= this._size; ++j) {
                this._map[i][j] = -1;
            }
        }
    }

    public void add(Segment s) {
        super.add(s);
        this._map[s.beg()][s.end()] = super.size() - 1;
    }

    private void addMissingSingles() {
        for (int i = 0; i < this._size; ++i) {
            if (this._map[i][i + 1] != -1) continue;
            super.add(new Segment(i, i + 1, 0));
            this._map[i][i + 1] = super.size() - 1;
        }
    }

    private void reMap() {
        int i;
        for (i = 0; i <= this._size; ++i) {
            for (int j = 0; j <= this._size; ++j) {
                this._map[i][j] = -1;
            }
        }
        for (i = 0; i < super.size(); ++i) {
            this._map[this.beg((int)i)][this.end((int)i)] = i;
        }
    }

    public String sgm(int idx) {
        if (idx < 0 || idx >= super.size()) {
            return null;
        }
        Object s = new String(this._tokens[((Segment)super.get(idx)).beg()]);
        for (int i = ((Segment)super.get(idx)).beg() + 1; i < ((Segment)super.get(idx)).end(); ++i) {
            s = (String)s + " " + this._tokens[i];
        }
        return s;
    }

    public int beg(int idx) {
        if (idx < 0 || idx >= super.size()) {
            return -1;
        }
        return ((Segment)super.get(idx)).beg();
    }

    public int end(int idx) {
        if (idx < 0 || idx >= super.size()) {
            return -1;
        }
        return ((Segment)super.get(idx)).end();
    }

    public int len(int idx) {
        if (idx < 0 || idx >= super.size()) {
            return -1;
        }
        return ((Segment)super.get(idx)).len();
    }

    public int conn(int idx) {
        if (idx < 0 || idx >= super.size()) {
            return -1;
        }
        return ((Segment)super.get(idx)).conn();
    }

    public Segments segmentation(int method) {
        int i;
        Segments smnt = new Segments(this._tokens);
        this.addMissingSingles();
        int bestid = -1;
        int bias = 0;
        int temp = 0;
        int next = -1;
        int[] maxScore = new int[super.size()];
        int[] nextid = new int[super.size()];
        for (i = 0; i < nextid.length; ++i) {
            nextid[i] = -1;
        }
        switch (method) {
            case 4: {
                bias += 50;
            }
            case 3: {
                bias += 30;
            }
            case 2: {
                bias += 10;
            }
            case 1: {
                bias += 10;
            }
            case 0: {
                int id;
                bestid = -1;
                for (i = this._tokens.length; i >= 0; --i) {
                    int j;
                    bestid = -1;
                    int maxsc = 0;
                    for (j = i + 1; j <= this._tokens.length; ++j) {
                        id = this._map[i][j];
                        if (id < 0 || maxScore[id] + 1 <= maxsc) continue;
                        bestid = id;
                        maxsc = maxScore[id] + 1;
                    }
                    if (maxsc > 0) {
                        --maxsc;
                    }
                    for (j = 0; j < i; ++j) {
                        id = this._map[j][i];
                        if (id < 0) continue;
                        nextid[id] = bestid;
                        int c = this.conn(id);
                        maxScore[id] = i - j <= 1 ? maxsc : (bias > 0 ? maxsc + (100 + (i - j - 2) * bias) * c / 100 : maxsc + c);
                    }
                }
                id = bestid;
                while (id != -1) {
                    smnt.add((Segment)super.get(id));
                    id = nextid[id];
                }
                break;
            }
            case 8: 
            case 9: {
                int pos = 0;
                while (pos < this._tokens.length) {
                    bestid = -1;
                    int bestval = -1;
                    for (i = pos + 1; i <= this._tokens.length; ++i) {
                        int id = this._map[pos][i];
                        if (id < 0 || method != 8 && (temp = this.len(id) > 1 ? this.conn(id) : 0) <= bestval) continue;
                        bestid = id;
                        bestval = temp;
                        next = i;
                    }
                    smnt.add((Segment)super.get(bestid));
                    pos = next;
                }
                break;
            }
            case 10: 
            case 11: {
                int pos = this._tokens.length;
                while (pos > 0) {
                    bestid = -1;
                    int bestval = -1;
                    for (i = pos - 1; i >= 0; --i) {
                        int id = this._map[i][pos];
                        if (id < 0 || method != 10 && (temp = this.len(id) > 1 ? this.conn(id) : 0) <= bestval) continue;
                        bestid = id;
                        bestval = temp;
                        next = i;
                    }
                    smnt.addFirst(super.get(bestid));
                    pos = next;
                }
                smnt.reMap();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: {
                this.buildSegmentationRecursive(method, smnt, 0, this._tokens.length);
            }
        }
        return smnt;
    }

    private void buildSegmentationRecursive(int method, Segments smnt, int b, int e) {
        int bestid = -1;
        int bestval1 = -1;
        int bestval2 = -1;
        block8: for (int i = 0; i < super.size(); ++i) {
            if (b > this.beg(i) || e < this.end(i)) continue;
            switch (method) {
                case 12: {
                    if (this.len(i) <= bestval1 && (this.len(i) != bestval1 || this.conn(i) <= bestval2)) continue block8;
                    bestid = i;
                    bestval1 = this.len(i);
                    bestval2 = this.conn(i);
                    continue block8;
                }
                case 13: {
                    if (this.len(i) <= bestval1 && (this.len(i) != bestval1 || this.beg(i) >= bestval2)) continue block8;
                    bestid = i;
                    bestval1 = this.len(i);
                    bestval2 = this.beg(i);
                    continue block8;
                }
                case 14: {
                    if (this.len(i) <= bestval1 && (this.len(i) != bestval1 || this.end(i) <= bestval2)) continue block8;
                    bestid = i;
                    bestval1 = this.len(i);
                    bestval2 = this.end(i);
                    continue block8;
                }
                case 7: {
                    int temp;
                    int n = temp = this.len(i) > 1 ? this.conn(i) : 0;
                    if (temp <= bestval1 && (temp != bestval1 || this.len(i) <= bestval2)) continue block8;
                    bestid = i;
                    bestval1 = temp;
                    bestval2 = this.len(i);
                    continue block8;
                }
                case 5: {
                    int temp;
                    int n = temp = this.len(i) > 1 ? this.conn(i) : 0;
                    if (temp <= bestval1 && (temp != bestval1 || this.beg(i) >= bestval2)) continue block8;
                    bestid = i;
                    bestval1 = temp;
                    bestval2 = this.beg(i);
                    continue block8;
                }
                case 6: {
                    int temp;
                    int n = temp = this.len(i) > 1 ? this.conn(i) : 0;
                    if (temp <= bestval1 && (temp != bestval1 || this.end(i) <= bestval2)) continue block8;
                    bestid = i;
                    bestval1 = temp;
                    bestval2 = this.end(i);
                    continue block8;
                }
                default: {
                    if (bestid >= 0) continue block8;
                    bestid = i;
                }
            }
        }
        if (bestid < 0) {
            return;
        }
        if (b < this.beg(bestid)) {
            this.buildSegmentationRecursive(method, smnt, b, this.beg(bestid));
        }
        smnt.add((Segment)super.get(bestid));
        if (e > this.end(bestid)) {
            this.buildSegmentationRecursive(method, smnt, this.end(bestid), e);
        }
    }
}

