/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.JsonNodeRawFlag;
import com.yahoo.vespa.flags.RawFlag;
import com.yahoo.vespa.flags.json.Condition;
import com.yahoo.vespa.flags.json.wire.WireRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Rule {
    private final List<Condition> andConditions;
    private final Optional<RawFlag> valueToApply;

    public Rule(Optional<RawFlag> valueToApply, Condition ... andConditions) {
        this(valueToApply, List.of(andConditions));
    }

    public Rule(Optional<RawFlag> valueToApply, List<Condition> andConditions) {
        this.andConditions = List.copyOf(andConditions);
        this.valueToApply = valueToApply;
    }

    public List<Condition> conditions() {
        return this.andConditions;
    }

    public boolean match(FetchVector fetchVector) {
        return this.andConditions.stream().allMatch(condition -> condition.test(fetchVector));
    }

    public boolean partialMatch(FetchVector fetchVector) {
        return this.andConditions.stream().allMatch(condition -> !fetchVector.hasDimension(condition.dimension()) || condition.test(fetchVector));
    }

    public Optional<Rule> partialResolve(FetchVector fetchVector) {
        ArrayList<Condition> newConditions = new ArrayList<Condition>();
        for (Condition condition : this.andConditions) {
            if (fetchVector.hasDimension(condition.dimension())) {
                if (condition.test(fetchVector)) continue;
                return Optional.empty();
            }
            newConditions.add(condition);
        }
        return Optional.of(new Rule(this.valueToApply, newConditions));
    }

    public Optional<RawFlag> getValueToApply() {
        return this.valueToApply;
    }

    public WireRule toWire() {
        WireRule wireRule = new WireRule();
        if (!this.andConditions.isEmpty()) {
            wireRule.andConditions = this.andConditions.stream().map(Condition::toWire).toList();
        }
        wireRule.value = this.valueToApply.map(RawFlag::asJsonNode).orElse(null);
        return wireRule;
    }

    public static Rule fromWire(WireRule wireRule) {
        List<Condition> conditions = wireRule.andConditions == null ? List.of() : wireRule.andConditions.stream().map(Condition::fromWire).toList();
        Optional<RawFlag> value = wireRule.value == null || wireRule.value.isNull() ? Optional.empty() : Optional.of(JsonNodeRawFlag.fromJsonNode(wireRule.value));
        return new Rule(value, conditions);
    }

    public String toString() {
        return "Rule{andConditions=" + String.valueOf(this.andConditions) + ", valueToApply=" + String.valueOf(this.valueToApply) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return this.andConditions.equals(rule.andConditions) && this.valueToApply.equals(rule.valueToApply);
    }

    public int hashCode() {
        return Objects.hash(this.andConditions, this.valueToApply);
    }
}

