/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.vespa.flags.custom.Sidecar;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record Sidecars(@JsonProperty(value="sidecars") List<Sidecar> sidecars) {
    public static Sidecars DEFAULT = new Sidecars(List.of());

    @JsonCreator
    public Sidecars {
        if (sidecars == null) {
            sidecars = List.of();
        }
        List<Integer> ids = sidecars.stream().map(Sidecar::id).toList();
        HashSet<Integer> uniqueIds = new HashSet<Integer>(ids);
        if (ids.size() != uniqueIds.size()) {
            throw new IllegalArgumentException("Sidecar IDs must be unique, actual: %s".formatted(ids.stream().map(String::valueOf).collect(Collectors.joining(", "))));
        }
    }
}

