/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import com.yahoo.vespa.flags.custom.Sidecars;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundBooleanFlag USE_NON_PUBLIC_ENDPOINT_FOR_TEST = Flags.defineFeatureFlag("use-non-public-endpoint-for-test", false, List.of("hakonhall"), "2025-03-19", "2025-07-01", "Whether to use non-public endpoint in test and staging environments (except Azure since it's not supported yet)", "Takes effect on next deployment of the application", Dimension.INSTANCE_ID, Dimension.VESPA_VERSION);
    public static final UnboundStringFlag SEARCH_MMAP_ADVISE = Flags.defineStringFlag("search-mmap-advise", "SEQUENTIAL", List.of("vekterli"), "2025-02-14", "2025-07-01", "Sets the MMAP advise setting used for disk based posting lists on the content node. Valid values are [NORMAL, RANDOM, SEQUENTIAL]", "Takes effect at redeployment (requires restart)", Dimension.INSTANCE_ID);
    public static final UnboundStringFlag RESPONSE_SEQUENCER_TYPE = Flags.defineStringFlag("response-sequencer-type", "ADAPTIVE", List.of("hmusum"), "2020-12-02", "2025-12-01", "Selects type of sequenced executor used for mbus responses, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag RESPONSE_NUM_THREADS = Flags.defineIntFlag("response-num-threads", 2, List.of("hmusum"), "2020-12-02", "2025-12-01", "Number of threads used for mbus responses, default is 2, negative number = numcores/4", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE = Flags.defineFeatureFlag("async-message-handling-on-schedule", true, List.of("hmusum"), "2020-12-02", "2025-12-01", "Optionally deliver async messages in own thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_JAVA_NUM_TARGETS = Flags.defineIntFlag("mbus-java-num-targets", 2, List.of("hmusum"), "2022-07-05", "2025-12-01", "Number of rpc targets per service", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_CPP_NUM_TARGETS = Flags.defineIntFlag("mbus-cpp-num-targets", 2, List.of("hmusum"), "2022-07-05", "2025-12-01", "Number of rpc targets per service", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag RPC_NUM_TARGETS = Flags.defineIntFlag("rpc-num-targets", 2, List.of("hmusum"), "2022-07-05", "2025-12-01", "Number of rpc targets per content node", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_JAVA_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("mbus-java-events-before-wakeup", 1, List.of("hmusum"), "2022-07-05", "2025-12-01", "Number write events before waking up transport thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_CPP_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("mbus-cpp-events-before-wakeup", 1, List.of("hmusum"), "2022-07-05", "2025-12-01", "Number write events before waking up transport thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag RPC_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("rpc-events-before-wakeup", 1, List.of("hmusum"), "2022-07-05", "2025-12-01", "Number write events before waking up transport thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_NUM_NETWORK_THREADS = Flags.defineIntFlag("mbus-num-network-threads", 1, List.of("hmusum"), "2022-07-01", "2025-12-01", "Number of threads used for mbus network", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS = Flags.defineIntFlag("max-activation-inhibited-out-of-sync-groups", 0, List.of("vekterli"), "2021-02-19", "2025-12-01", "Allows replicas in up to N content groups to not be activated for query visibility if they are out of sync with a majority of other replicas", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag USE_V8_GEO_POSITIONS = Flags.defineFeatureFlag("use-v8-geo-positions", true, List.of("arnej"), "2021-11-15", "2025-12-01", "Use Vespa 8 types and formats for geographical positions", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag ENABLE_OTELCOL = Flags.defineFeatureFlag("enable-otel-collector", false, List.of("olaa"), "2022-09-23", "2025-07-01", "Whether an OpenTelemetry collector should be enabled", "Takes effect at next tick", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static final UnboundListFlag<String> OTELCOL_LOGS = Flags.defineListFlag("otelcol-logs", List.of(), String.class, List.of("olaa"), "2024-01-15", "2025-07-01", "Determines log files handled by the OpenTelemetry collector", "Takes effect at next tick", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static final UnboundStringFlag CORE_ENCRYPTION_PUBLIC_KEY_ID = Flags.defineStringFlag("core-encryption-public-key-id", "", List.of("vekterli"), "2022-11-03", "2025-07-01", "Specifies which public key to use for core dump encryption.", "Takes effect on the next tick.", Dimension.NODE_TYPE, Dimension.HOSTNAME);
    public static final UnboundListFlag<String> ZONAL_WEIGHTED_ENDPOINT_RECORDS = Flags.defineListFlag("zonal-weighted-endpoint-records", List.of(), String.class, List.of("hmusum"), "2023-12-15", "2025-07-01", "A list of weighted (application) endpoint fqdns for which we should use zonal endpoints as targets, not LBs.", "Takes effect at redeployment from controller", new Dimension[0]);
    public static final UnboundListFlag<String> WEIGHTED_ENDPOINT_RECORD_TTL = Flags.defineListFlag("weighted-endpoint-record-ttl", List.of(), String.class, List.of("hmusum"), "2023-05-16", "2025-07-01", "A list of endpoints and custom TTLs, on the form \"endpoint-fqdn:TTL-seconds\". Where specified, CNAME records are used instead of the default ALIAS records, which have a default 60s TTL.", "Takes effect at redeployment from controller", new Dimension[0]);
    public static final UnboundBooleanFlag WRITE_CONFIG_SERVER_SESSION_DATA_AS_ONE_BLOB = Flags.defineFeatureFlag("write-config-server-session-data-as-blob", false, List.of("hmusum"), "2023-07-19", "2025-12-01", "Whether to write config server session data in one blob or as individual paths", "Takes effect immediately", new Dimension[0]);
    public static final UnboundBooleanFlag READ_CONFIG_SERVER_SESSION_DATA_AS_ONE_BLOB = Flags.defineFeatureFlag("read-config-server-session-data-as-blob", false, List.of("hmusum"), "2023-07-19", "2025-12-01", "Whether to read config server session data from session data blob or from individual paths", "Takes effect immediately", new Dimension[0]);
    public static final UnboundBooleanFlag MORE_WIREGUARD = Flags.defineFeatureFlag("more-wireguard", false, List.of("andreer"), "2023-08-21", "2025-09-01", "Use wireguard in INternal enCLAVES", "Takes effect on next host-admin run", Dimension.HOSTNAME, Dimension.CLOUD_ACCOUNT);
    public static final UnboundBooleanFlag IPV6_AWS_TARGET_GROUPS = Flags.defineFeatureFlag("ipv6-aws-target-groups", false, List.of("andreer"), "2023-08-28", "2025-09-01", "Always use IPv6 target groups for load balancers in aws", "Takes effect on next load-balancer provisioning", Dimension.HOSTNAME, Dimension.CLOUD_ACCOUNT);
    public static final UnboundBooleanFlag PROVISION_IPV6_ONLY_AWS = Flags.defineFeatureFlag("provision-ipv6-only", false, List.of("andreer"), "2023-08-28", "2025-09-01", "Provision without private IPv4 addresses in INternal enCLAVES in AWS", "Takes effect on next host provisioning / run of host-admin", Dimension.HOSTNAME, Dimension.CLOUD_ACCOUNT);
    public static final UnboundIntFlag CONTENT_LAYER_METADATA_FEATURE_LEVEL = Flags.defineIntFlag("content-layer-metadata-feature-level", 1, List.of("vekterli"), "2022-09-12", "2025-12-01", "Value semantics: 0) legacy behavior, 1) operation cancellation, 2) operation cancellation and ephemeral content node sequence numbers for bucket replicas", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag SEARCH_HANDLER_THREADPOOL = Flags.defineIntFlag("search-handler-threadpool", 10, List.of("bjorncs"), "2023-10-01", "2025-12-01", "Adjust search handler threadpool size", "Takes effect at redeployment", Dimension.APPLICATION);
    public static final UnboundStringFlag ENDPOINT_CONFIG = Flags.defineStringFlag("endpoint-config", "legacy", List.of("andreer", "olaa"), "2023-10-06", "2025-09-01", "Set the endpoint config to use for an application. Must be 'legacy', 'combined' or 'generated'. See EndpointConfig for further details", "Takes effect on next deployment through controller", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static UnboundBooleanFlag LOGSERVER_OTELCOL_AGENT = Flags.defineFeatureFlag("logserver-otelcol-agent", false, List.of("olaa"), "2024-04-03", "2025-07-01", "Whether logserver container should run otel agent", "Takes effect at redeployment", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag USE_LEGACY_WAND_QUERY_PARSING = Flags.defineFeatureFlag("use-legacy-wand-query-parsing", true, List.of("arnej"), "2023-07-26", "2025-12-31", "If true, force legacy mode for weakAnd query parsing", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag MONITORING_JWT = Flags.defineFeatureFlag("monitoring-jwt", false, List.of("olaa"), "2024-07-05", "2025-07-01", "Whether a monitoring JWT should be issued by the controller", "Takes effect immediately", Dimension.TENANT_ID, Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundBooleanFlag SNAPSHOTS_ENABLED = Flags.defineFeatureFlag("snapshots-enabled", false, List.of("olaa"), "2024-10-22", "2025-07-01", "Whether node snapshots should be created when host storage is discarded", "Takes effect immediately", new Dimension[0]);
    public static final UnboundLongFlag ZOOKEEPER_PRE_ALLOC_SIZE_KIB = Flags.defineLongFlag("zookeeper-pre-alloc-size", 65536L, List.of("hmusum"), "2024-11-11", "2025-12-01", "Setting for zookeeper.preAllocSize flag in KiB, can be reduced from default value e.g. when running tests to avoid writing a large, sparse, mostly unused file", "Takes effect on restart of Docker container", new Dimension[0]);
    public static final UnboundBooleanFlag ENFORCE_EMAIL_DOMAIN_SSO = Flags.defineFeatureFlag("enforce-email-domain-sso", false, List.of("eirik"), "2024-11-07", "2025-07-01", "Enforce SSO login for an email domain", "Takes effect immediately", Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundListFlag<String> RESTRICT_USERS_TO_DOMAIN = Flags.defineListFlag("restrict-users-to-domain", List.of(), String.class, List.of("eirik"), "2024-11-07", "2025-07-01", "Only allow adding specific email domains as user to tenant", "Takes effect immediately", Dimension.TENANT_ID);
    public static final UnboundBooleanFlag USE_LEGACY_STORE = Flags.defineFeatureFlag("use-legacy-trust-store", false, List.of("marlon"), "2024-12-05", "2025-07-01", "Use legacy trust store for CA, or new one", "Takes effect on restart of OCI containers", new Dimension[0]);
    public static final UnboundIntFlag DOCUMENT_V1_QUEUE_SIZE = Flags.defineIntFlag("document-v1-queue-size", 0, List.of("bjorncs"), "2025-01-14", "2025-12-01", "Size of the document v1 queue. Use -1 for default as determined by 'document-operation-executor.def'", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag INCREMENTAL_USAGE_CALCULATION = Flags.defineFeatureFlag("incremental-usage-calculation", false, List.of("evgiz"), "2025-02-27", "2025-09-01", "Use new incremental usage calculation for node snapshots", "Takes effect at controller startup", new Dimension[0]);
    public static final UnboundIntFlag MAX_CONTENT_NODE_MAINTENANCE_OP_CONCURRENCY = Flags.defineIntFlag("max-content-node-maintenance-op-concurrency", -1, List.of("vekterli"), "2025-03-07", "2025-09-01", "Sets the maximum concurrency for maintenance-related operations on content nodes. Only intended as a manual emergency brake feature if a system is suddenly incapable of handling regular maintenance pressure.", "Takes effect immediately", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MAX_DISTRIBUTOR_DOCUMENT_OPERATION_SIZE_MIB = Flags.defineIntFlag("max-distributor-document-operation-size-mib", -1, List.of("vekterli"), "2025-03-17", "2025-10-01", "Sets the maximum size in MiB of a document operation (Put or Update) that a distributor will accept when it arrives over the Document API. Any value outside (1, 2048) implies effectively unbounded behavior. Setting this value too low will have the obvious consequences.", "Takes effect immediately", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag COPY_LEGACY_CA = Flags.defineFeatureFlag("copy-legacy-ca", false, List.of("olaa"), "2025-03-27", "2025-07-01", "Whether legacy CA should be copied from host to container", "Takes effect on container startup", Dimension.TENANT_ID, Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag DEFER_OS_UPGRADE = Flags.defineFeatureFlag("defer-os-upgrade", false, List.of("olaa"), "2025-04-09", "2025-07-01", "Whether OS upgrade should be deferred", "Takes effect immediately", Dimension.CLOUD_ACCOUNT);
    public static final UnboundJacksonFlag<Sidecars> SIDECARS_FOR_TEST = Flags.defineJacksonFlag("sidecars-for-test", Sidecars.createDisabled(), Sidecars.class, List.of("glebashnik"), "2025-04-25", "2025-07-01", "Specifies configuration for sidecars to testing provisioning", "Takes effect at redeployment", Dimension.APPLICATION);
    public static final UnboundBooleanFlag CREATE_TENANT_ROLES = Flags.defineFeatureFlag("create-tenant-roles", true, List.of("oyving"), "2025-04-28", "2025-07-01", "Whether to create tenant specific roles", "Takes effect immediately", Dimension.TENANT_ID);
    public static final UnboundBooleanFlag USE_TRITON = Flags.defineFeatureFlag("use-triton", false, List.of("bjorncs"), "2025-04-30", "2026-01-04", "Whether to use Triton as ONNX runtime", "Takes effect at redeployment", new Dimension[0]);
    public static final UnboundBooleanFlag DELETE_TENANT_ROLES = Flags.defineFeatureFlag("delete-tenant-roles", false, List.of("andreer"), "2025-05-05", "2025-07-01", "Whether to delete tenant specific roles", "Role deletion happens when tenant is next processed by TenantRoleMaintainer", Dimension.TENANT_ID);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.defineStringFlag(flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, (String value) -> true, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Predicate<String> validator, Dimension ... dimensions) {
        return Flags.define((i, d, v) -> new UnboundStringFlag(i, (String)d, v, validator), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Predicate<List<T>> validator, Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec, validator), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, owners, Flags.parseDate(createdAt), Flags.parseDate(expiresAt), description, modificationEffect, dimensions);
        if (flags.put(id, definition) != null) {
            throw new IllegalStateException("There are multiple definitions of the " + String.valueOf(id) + " flag");
        }
        return unboundFlag;
    }

    private static Instant parseDate(String rawDate) {
        return DateTimeFormatter.ISO_DATE.parse((CharSequence)rawDate, LocalDate::from).atStartOfDay().toInstant(ZoneOffset.UTC);
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting(FlagId ... flagsToKeep) {
        return new Replacer(flagsToKeep);
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer(FlagId ... flagsToKeep) {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
            List.of(flagsToKeep).forEach(id -> flags.put((FlagId)id, this.savedFlags.get(id)));
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }
}

